/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.webhook;

import com.cloudbees.jenkins.GitHubRepositoryName;
import com.cloudbees.jenkins.GitHubRepositoryNameContributor;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Item;
import hudson.model.Job;
import hudson.util.Secret;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.jenkinsci.plugins.github.GitHubPlugin;
import org.jenkinsci.plugins.github.admin.GitHubHookRegisterProblemMonitor;
import org.jenkinsci.plugins.github.config.GitHubServerConfig;
import org.jenkinsci.plugins.github.config.HookSecretConfig;
import org.jenkinsci.plugins.github.extension.GHEventsSubscriber;
import org.jenkinsci.plugins.github.util.FluentIterableWrapper;
import org.jenkinsci.plugins.github.util.misc.NullSafeFunction;
import org.jenkinsci.plugins.github.util.misc.NullSafePredicate;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GHHook;
import org.kohsuke.github.GHRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebhookManager.class);
    private final URL endpoint;

    protected WebhookManager(URL endpoint) {
        this.endpoint = endpoint;
    }

    public static WebhookManager forHookUrl(URL endpoint) {
        return new WebhookManager(endpoint);
    }

    @Deprecated
    public Runnable registerFor(Job<?, ?> project) {
        return this.registerFor((Item)project);
    }

    public Runnable registerFor(final Item item) {
        final Collection<GitHubRepositoryName> names = GitHubRepositoryNameContributor.parseAssociatedNames(item);
        final List<GHEvent> events = FluentIterableWrapper.from(GHEventsSubscriber.all()).filter(GHEventsSubscriber.isApplicableFor(item)).transformAndConcat(GHEventsSubscriber.extractEvents()).toList();
        return new Runnable(){

            @Override
            public void run() {
                if (events.isEmpty()) {
                    LOGGER.debug("No any subscriber interested in {}, but hooks creation launched, skipping...", (Object)item.getFullName());
                    return;
                }
                LOGGER.info("GitHub webhooks activated for job {} with {} (events: {})", new Object[]{item.getFullName(), names, events});
                FluentIterableWrapper.from(names).transform(WebhookManager.this.createHookSubscribedTo(events)).filter((Predicate<GHHook>)Predicates.notNull()).filter(WebhookManager.this.log("Created hook")).toList();
            }
        };
    }

    public void unregisterFor(GitHubRepositoryName name, List<GitHubRepositoryName> aliveRepos) {
        try {
            GHRepository repo = this.repoWithWebhookAccess(name);
            if (repo == null) {
                return;
            }
            LOGGER.debug("Check {} for redundant hooks...", (Object)repo);
            Predicate predicate = aliveRepos.contains(name) ? this.serviceWebhookFor(this.endpoint) : Predicates.or(this.serviceWebhookFor(this.endpoint), this.webhookFor(this.endpoint));
            FluentIterableWrapper.from((Iterable)this.fetchHooks().apply((Object)repo)).filter(predicate).filter(this.deleteWebhook()).filter(this.log("Deleted hook")).toList();
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to remove hook from {}", (Object)name, (Object)t);
            GitHubHookRegisterProblemMonitor.get().registerProblem(name, t);
        }
    }

    private GHRepository repoWithWebhookAccess(GitHubRepositoryName name) {
        FluentIterableWrapper<GHRepository> reposAllowedtoManageWebhooks = FluentIterableWrapper.from(name.resolve(GitHubServerConfig.allowedToManageHooks()));
        if (!reposAllowedtoManageWebhooks.first().isPresent()) {
            LOGGER.debug("There are no github repos configured to allow webhook management for: {}", (Object)name);
            return null;
        }
        com.google.common.base.Optional<GHRepository> repoWithAdminAccess = reposAllowedtoManageWebhooks.firstMatch(this.withAdminAccess());
        if (!repoWithAdminAccess.isPresent()) {
            LOGGER.debug("None of the github repos configured have admin access for: {}", (Object)name);
            return null;
        }
        GHRepository repo = (GHRepository)repoWithAdminAccess.get();
        return repo;
    }

    protected Function<GitHubRepositoryName, GHHook> createHookSubscribedTo(final List<GHEvent> events) {
        return new NullSafeFunction<GitHubRepositoryName, GHHook>(){

            @Override
            protected GHHook applyNullSafe(@NonNull GitHubRepositoryName name) {
                try {
                    GHRepository repo = WebhookManager.this.repoWithWebhookAccess(name);
                    if (repo == null) {
                        return null;
                    }
                    Validate.notEmpty((Collection)events, (String)"Events list for hook can't be empty", (Object[])new Object[0]);
                    ImmutableSet<GHHook> hooks = FluentIterableWrapper.from((Iterable)WebhookManager.this.fetchHooks().apply((Object)repo)).filter(WebhookManager.this.webhookFor(WebhookManager.this.endpoint)).toSet();
                    ImmutableSet<GHEvent> alreadyRegistered = FluentIterableWrapper.from(hooks).transformAndConcat(WebhookManager.this.eventsFromHook()).toSet();
                    if (hooks.size() == 1 && alreadyRegistered.containsAll(events)) {
                        LOGGER.debug("Hook already registered for events {}", (Object)events);
                        return null;
                    }
                    ImmutableSet<GHEvent> merged = FluentIterableWrapper.from(alreadyRegistered).append(events).toSet();
                    FluentIterableWrapper.from(hooks).filter(WebhookManager.this.deleteWebhook()).filter(WebhookManager.this.log("Replaced hook")).toList();
                    return (GHHook)WebhookManager.this.createWebhook(WebhookManager.this.endpoint, (Set<GHEvent>)merged).apply((Object)repo);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to add GitHub webhook for {}", (Object)name, (Object)e);
                    GitHubHookRegisterProblemMonitor.get().registerProblem(name, e);
                    return null;
                }
            }
        };
    }

    protected Predicate<GHHook> log(final String format) {
        return new NullSafePredicate<GHHook>(){

            @Override
            protected boolean applyNullSafe(@NonNull GHHook input) {
                LOGGER.debug(String.format("%s {} (events: {})", format), (Object)input.getUrl(), (Object)input.getEvents());
                return true;
            }
        };
    }

    protected Predicate<GHRepository> withAdminAccess() {
        return new NullSafePredicate<GHRepository>(){

            @Override
            protected boolean applyNullSafe(@NonNull GHRepository repo) {
                return repo.hasAdminAccess();
            }
        };
    }

    protected Predicate<GHHook> serviceWebhookFor(final URL url) {
        return new NullSafePredicate<GHHook>(){

            @Override
            protected boolean applyNullSafe(@NonNull GHHook hook) {
                return hook.getName().equals("jenkins") && ((String)hook.getConfig().get("jenkins_hook_url")).equals(url.toExternalForm());
            }
        };
    }

    protected Predicate<GHHook> webhookFor(final URL url) {
        return new NullSafePredicate<GHHook>(){

            @Override
            protected boolean applyNullSafe(@NonNull GHHook hook) {
                return hook.getName().equals("web") && ((String)hook.getConfig().get("url")).equals(url.toExternalForm());
            }
        };
    }

    protected Function<GHHook, Iterable<GHEvent>> eventsFromHook() {
        return new NullSafeFunction<GHHook, Iterable<GHEvent>>(){

            @Override
            protected Iterable<GHEvent> applyNullSafe(@NonNull GHHook input) {
                return input.getEvents();
            }
        };
    }

    protected Function<GHRepository, List<GHHook>> fetchHooks() {
        return new NullSafeFunction<GHRepository, List<GHHook>>(){

            @Override
            protected List<GHHook> applyNullSafe(@NonNull GHRepository repo) {
                try {
                    return repo.getHooks();
                }
                catch (IOException e) {
                    throw new GHException("Failed to fetch post-commit hooks", (Throwable)e);
                }
            }
        };
    }

    protected Function<GHRepository, GHHook> createWebhook(final URL url, final Set<GHEvent> events) {
        return new NullSafeFunction<GHRepository, GHHook>(){

            @Override
            protected GHHook applyNullSafe(@NonNull GHRepository repo) {
                try {
                    HashMap<String, String> config = new HashMap<String, String>();
                    config.put("url", url.toExternalForm());
                    config.put("content_type", "json");
                    Optional<Secret> secret = GitHubPlugin.configuration().getHookSecretConfigs().stream().map(HookSecretConfig::getHookSecret).filter(Objects::nonNull).findFirst();
                    if (secret.isPresent()) {
                        config.put("secret", secret.get().getPlainText());
                    }
                    return repo.createHook("web", config, (Collection)events, true);
                }
                catch (IOException e) {
                    throw new GHException("Failed to create hook", (Throwable)e);
                }
            }
        };
    }

    protected Predicate<GHHook> deleteWebhook() {
        return new NullSafePredicate<GHHook>(){

            @Override
            protected boolean applyNullSafe(@NonNull GHHook hook) {
                try {
                    hook.delete();
                    return true;
                }
                catch (IOException e) {
                    throw new GHException("Failed to delete post-commit hook", (Throwable)e);
                }
            }
        };
    }
}

