/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.webhook;

public enum SignatureAlgorithm {
    SHA256("sha256", "X-Hub-Signature-256", "HmacSHA256"),
    SHA1("sha1", "X-Hub-Signature", "HmacSHA1");

    private final String prefix;
    private final String headerName;
    private final String javaAlgorithm;
    public static final String DEFAULT_ALGORITHM_PROPERTY = "jenkins.github.webhook.signature.default";

    public static SignatureAlgorithm getDefault() {
        return SignatureAlgorithm.getDefaultAlgorithm();
    }

    private SignatureAlgorithm(String prefix, String headerName, String javaAlgorithm) {
        this.prefix = prefix;
        this.headerName = headerName;
        this.javaAlgorithm = javaAlgorithm;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public String getJavaAlgorithm() {
        return this.javaAlgorithm;
    }

    public String getSignaturePrefix() {
        return this.prefix + "=";
    }

    private static SignatureAlgorithm getDefaultAlgorithm() {
        String property = System.getProperty(DEFAULT_ALGORITHM_PROPERTY);
        if (property == null || property.trim().isEmpty()) {
            return SHA256;
        }
        try {
            return SignatureAlgorithm.valueOf(property.trim().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return SHA256;
        }
    }
}

