/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.webhook;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import hudson.util.Secret;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.main.modules.instance_identity.InstanceIdentity;
import org.jenkinsci.plugins.github.GitHubPlugin;
import org.jenkinsci.plugins.github.config.HookSecretConfig;
import org.jenkinsci.plugins.github.util.FluentIterableWrapper;
import org.jenkinsci.plugins.github.webhook.GHWebhookSignature;
import org.jenkinsci.plugins.github.webhook.SignatureAlgorithm;
import org.kohsuke.github.GHEvent;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.Interceptor;
import org.kohsuke.stapler.interceptor.InterceptorAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.FIELD})
@InterceptorAnnotation(value=Processor.class)
public @interface RequirePostWithGHHookPayload {

    public static class Processor
    extends Interceptor {
        private static final Logger LOGGER = LoggerFactory.getLogger(Processor.class);
        @Deprecated
        public static final String SIGNATURE_HEADER = "X-Hub-Signature";
        public static final String SIGNATURE_HEADER_SHA256 = "X-Hub-Signature-256";
        public static final String SHA1_PREFIX = "sha1=";
        public static final String SHA256_PREFIX = "sha256=";

        public Object invoke(StaplerRequest2 req, StaplerResponse2 rsp, Object instance, Object[] arguments) throws IllegalAccessException, InvocationTargetException, ServletException {
            this.shouldBePostMethod(req);
            this.returnsInstanceIdentityIfLocalUrlTest(req);
            this.shouldContainParseablePayload(arguments);
            this.shouldProvideValidSignature(req, arguments);
            return this.target.invoke(req, rsp, instance, arguments);
        }

        protected void shouldBePostMethod(StaplerRequest2 request) throws InvocationTargetException {
            if (!request.getMethod().equals("POST")) {
                throw new InvocationTargetException((Throwable)HttpResponses.error((int)405, (String)"Method POST required"));
            }
        }

        protected void returnsInstanceIdentityIfLocalUrlTest(StaplerRequest2 req) throws InvocationTargetException {
            if (req.getHeader("X-Jenkins-Validation") != null) {
                throw new InvocationTargetException((Throwable)new HttpResponses.HttpResponseException(){

                    public void generateResponse(StaplerRequest2 req, StaplerResponse2 rsp, Object node) throws IOException, ServletException {
                        RSAPublicKey key = new InstanceIdentity().getPublic();
                        rsp.setStatus(200);
                        rsp.setHeader("X-Instance-Identity", new String(Base64.encodeBase64((byte[])key.getEncoded()), Charsets.UTF_8));
                    }
                });
            }
        }

        protected void shouldContainParseablePayload(Object[] arguments) throws InvocationTargetException {
            this.isTrue(arguments.length == 2, "GHHook root action should take <(GHEvent) event> and <(String) payload> only");
            FluentIterableWrapper from = FluentIterableWrapper.from(Lists.newArrayList((Object[])arguments));
            this.isTrue(from.firstMatch(Predicates.instanceOf(GHEvent.class)).isPresent(), "Hook should contain event type");
            this.isTrue(StringUtils.isNotBlank((CharSequence)((String)from.firstMatch(Predicates.instanceOf(String.class)).or((Object)""))), "Hook should contain payload");
        }

        protected void shouldProvideValidSignature(StaplerRequest2 req, Object[] args) throws InvocationTargetException {
            List<HookSecretConfig> secretConfigs = GitHubPlugin.configuration().getHookSecretConfigs();
            if (!secretConfigs.isEmpty()) {
                boolean validSignatureFound = false;
                for (HookSecretConfig config : secretConfigs) {
                    Secret secret = config.getHookSecret();
                    if (secret == null) continue;
                    SignatureAlgorithm algorithm = config.getSignatureAlgorithm();
                    String headerName = algorithm.getHeaderName();
                    String expectedPrefix = algorithm.getSignaturePrefix();
                    Optional signHeader = Optional.fromNullable((Object)req.getHeader(headerName));
                    if (!signHeader.isPresent()) {
                        LOGGER.debug("No signature header {} found for algorithm {}", (Object)headerName, (Object)algorithm);
                        continue;
                    }
                    String fullSignature = (String)signHeader.get();
                    if (!fullSignature.startsWith(expectedPrefix)) {
                        LOGGER.debug("Signature header {} does not start with expected prefix {}", (Object)fullSignature, (Object)expectedPrefix);
                        continue;
                    }
                    String digest = StringUtils.substringAfter((String)fullSignature, (String)expectedPrefix);
                    LOGGER.trace("Verifying {} signature from header {}", (Object)algorithm, (Object)fullSignature);
                    boolean isValid = GHWebhookSignature.webhookSignature(this.payloadFrom(req, args), secret).matches(digest, algorithm);
                    if (isValid) {
                        validSignatureFound = true;
                        if (algorithm == SignatureAlgorithm.SHA1) {
                            LOGGER.warn("Using deprecated SHA-1 signature validation. Consider upgrading webhook configuration to use SHA-256 for enhanced security.");
                            break;
                        }
                        LOGGER.debug("Successfully validated {} signature", (Object)algorithm);
                        break;
                    }
                    LOGGER.debug("Signature validation failed for algorithm {}", (Object)algorithm);
                }
                this.isTrue(validSignatureFound, "No valid signature found. Ensure webhook is configured with a supported signature algorithm (SHA-256 recommended, SHA-1 for legacy compatibility).");
            }
        }

        protected String payloadFrom(StaplerRequest2 req, Object[] args) {
            String parsedPayload = (String)args[1];
            if (req.getContentType().equals("application/json")) {
                return parsedPayload;
            }
            if (req.getContentType().equals("application/x-www-form-urlencoded")) {
                try {
                    return String.format("payload=%s", URLEncoder.encode(parsedPayload, StandardCharsets.UTF_8.toString()));
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            } else {
                LOGGER.error("Unknown content type {}", (Object)req.getContentType());
            }
            return "";
        }

        private void isTrue(boolean condition, String msg) throws InvocationTargetException {
            if (!condition) {
                throw new InvocationTargetException((Throwable)HttpResponses.errorWithoutStack((int)400, (String)msg));
            }
        }
    }
}

