/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.webhook;

import com.google.common.base.Preconditions;
import hudson.util.Secret;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.jenkinsci.plugins.github.webhook.SignatureAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GHWebhookSignature {
    private static final Logger LOGGER = LoggerFactory.getLogger(GHWebhookSignature.class);
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    private static final String HMAC_SHA256_ALGORITHM = "HmacSHA256";
    public static final String INVALID_SIGNATURE = "COMPUTED_INVALID_SIGNATURE";
    private final String payload;
    private final Secret secret;

    private GHWebhookSignature(String payload, Secret secret) {
        this.payload = payload;
        this.secret = secret;
    }

    public static GHWebhookSignature webhookSignature(String payload, Secret secret) {
        Preconditions.checkNotNull((Object)payload, (Object)"Payload can't be null");
        Preconditions.checkNotNull((Object)secret, (Object)"Secret should be defined to compute sign");
        return new GHWebhookSignature(payload, secret);
    }

    @Deprecated
    public String sha1() {
        return this.computeSignature(HMAC_SHA1_ALGORITHM);
    }

    public String sha256() {
        return this.computeSignature(HMAC_SHA256_ALGORITHM);
    }

    private String computeSignature(String algorithm) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(this.secret.getPlainText().getBytes(StandardCharsets.UTF_8), algorithm);
            Mac mac = Mac.getInstance(algorithm);
            mac.init(keySpec);
            byte[] rawHMACBytes = mac.doFinal(this.payload.getBytes(StandardCharsets.UTF_8));
            return Hex.encodeHexString((byte[])rawHMACBytes);
        }
        catch (Exception e) {
            LOGGER.error("Error computing {} signature", (Object)algorithm, (Object)e);
            return INVALID_SIGNATURE;
        }
    }

    @Deprecated
    public boolean matches(String digest) {
        return this.matches(digest, SignatureAlgorithm.SHA1);
    }

    public boolean matches(String digest, SignatureAlgorithm algorithm) {
        String computed;
        switch (algorithm) {
            case SHA256: {
                computed = this.sha256();
                break;
            }
            case SHA1: {
                computed = this.sha1();
                break;
            }
            default: {
                LOGGER.warn("Unsupported signature algorithm: {}", (Object)algorithm);
                return false;
            }
        }
        LOGGER.trace("Signature validation: algorithm={} calculated={} provided={}", new Object[]{algorithm, computed, digest});
        if (digest == null && computed == null) {
            return true;
        }
        if (digest == null || computed == null) {
            return false;
        }
        return MessageDigest.isEqual(computed.getBytes(StandardCharsets.UTF_8), digest.getBytes(StandardCharsets.UTF_8));
    }
}

