/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.webhook;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.jenkinsci.plugins.github.util.misc.NullSafeFunction;
import org.kohsuke.stapler.AnnotationHandler;
import org.kohsuke.stapler.InjectedParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
@Documented
@InjectedParameter(value=PayloadHandler.class)
public @interface GHEventPayload {

    public static class PayloadHandler
    extends AnnotationHandler<GHEventPayload> {
        private static final Logger LOGGER = LoggerFactory.getLogger(PayloadHandler.class);
        public static final String APPLICATION_JSON = "application/json";
        public static final String FORM_URLENCODED = "application/x-www-form-urlencoded";
        private static final Map<String, Function<StaplerRequest2, String>> PAYLOAD_PROCESS = ImmutableMap.builder().put((Object)"application/json", PayloadHandler.fromApplicationJson()).put((Object)"application/x-www-form-urlencoded", PayloadHandler.fromForm()).build();

        public Object parse(StaplerRequest2 req, GHEventPayload a, Class type, String param) throws ServletException {
            if (((StaplerRequest2)Validate.notNull((Object)req, (String)"Why StaplerRequest2 is null?", (Object[])new Object[0])).getHeader("X-Jenkins-Validation") != null) {
                return null;
            }
            String contentType = req.getContentType();
            if (!PAYLOAD_PROCESS.containsKey(contentType)) {
                LOGGER.error("Unknown content type {}", (Object)contentType);
                return null;
            }
            String payload = (String)PAYLOAD_PROCESS.get(contentType).apply((Object)req);
            LOGGER.trace("Payload {}", (Object)payload);
            return payload;
        }

        protected static Function<StaplerRequest2, String> fromForm() {
            return new NullSafeFunction<StaplerRequest2, String>(){

                @Override
                protected String applyNullSafe(@NonNull StaplerRequest2 request) {
                    return request.getParameter("payload");
                }
            };
        }

        protected static Function<StaplerRequest2, String> fromApplicationJson() {
            return new NullSafeFunction<StaplerRequest2, String>(){

                @Override
                protected String applyNullSafe(@NonNull StaplerRequest2 request) {
                    try {
                        return IOUtils.toString((InputStream)request.getInputStream(), (Charset)Charsets.UTF_8);
                    }
                    catch (IOException e) {
                        LOGGER.error("Can't get payload from request: {}", (Object)e.getMessage());
                        return null;
                    }
                }
            };
        }
    }
}

