/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.webhook;

import jakarta.servlet.ServletException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.kohsuke.github.GHEvent;
import org.kohsuke.stapler.AnnotationHandler;
import org.kohsuke.stapler.InjectedParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
@Documented
@InjectedParameter(value=PayloadHandler.class)
public @interface GHEventHeader {

    public static class PayloadHandler
    extends AnnotationHandler<GHEventHeader> {
        public static final String EVENT_HEADER = "X-GitHub-Event";
        private static final Logger LOGGER = LoggerFactory.getLogger(PayloadHandler.class);

        public Object parse(StaplerRequest2 req, GHEventHeader a, Class type, String param) throws ServletException {
            Validate.isTrue((boolean)GHEvent.class.isAssignableFrom(type), (String)"Parameter '%s' should has type %s, not %s", (Object[])new Object[]{param, GHEvent.class.getName(), type.getName()});
            String header = req.getHeader(EVENT_HEADER);
            LOGGER.debug("Header {} -> {}", (Object)EVENT_HEADER, (Object)header);
            if (header == null) {
                return null;
            }
            try {
                return GHEvent.valueOf((String)StringUtils.upperCase((String)header));
            }
            catch (IllegalArgumentException e) {
                LOGGER.debug("Unknown event - {}", (Object)e.getMessage());
                return null;
            }
        }
    }
}

