/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.util;

import com.cloudbees.jenkins.GitHubRepositoryName;
import com.cloudbees.jenkins.GitHubRepositoryNameContributor;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.BuildableItem;
import hudson.model.Item;
import hudson.model.Job;
import hudson.triggers.Trigger;
import java.util.Collection;
import java.util.Map;
import jenkins.model.ParameterizedJobMixIn;
import org.jenkinsci.plugins.github.extension.GHEventsSubscriber;

public final class JobInfoHelpers {
    private JobInfoHelpers() {
        throw new IllegalAccessError("Do not instantiate it");
    }

    public static <ITEM extends Item> Predicate<ITEM> withTrigger(Class<? extends Trigger> clazz) {
        return item -> JobInfoHelpers.triggerFrom(item, clazz) != null;
    }

    public static <ITEM extends Item> Predicate<ITEM> isBuildable() {
        return item -> item instanceof Job ? ((Job)item).isBuildable() : item instanceof BuildableItem;
    }

    public static <ITEM extends Item> Function<ITEM, Collection<GitHubRepositoryName>> associatedNames() {
        return GitHubRepositoryNameContributor::parseAssociatedNames;
    }

    public static <ITEM extends Item> Predicate<ITEM> isAlive() {
        return item -> GHEventsSubscriber.all().stream().anyMatch(GHEventsSubscriber.isApplicableFor(item));
    }

    @Deprecated
    @CheckForNull
    public static <T extends Trigger> T triggerFrom(Job<?, ?> job, Class<T> tClass) {
        return JobInfoHelpers.triggerFrom(job, tClass);
    }

    @CheckForNull
    public static <T extends Trigger> T triggerFrom(Item item, Class<T> tClass) {
        if (item instanceof ParameterizedJobMixIn.ParameterizedJob) {
            ParameterizedJobMixIn.ParameterizedJob pJob = (ParameterizedJobMixIn.ParameterizedJob)item;
            Map triggerMap = pJob.getTriggers();
            for (Trigger candidate : triggerMap.values()) {
                if (!tClass.isInstance(candidate)) continue;
                return (T)((Trigger)tClass.cast(candidate));
            }
        }
        return null;
    }

    public static <T extends Job> ParameterizedJobMixIn asParameterizedJobMixIn(final T job) {
        return new ParameterizedJobMixIn(){

            protected Job asJob() {
                return job;
            }
        };
    }
}

