/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildData;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.lib.ObjectId;
import org.jenkinsci.plugins.github.util.Messages;

public final class BuildDataHelper {
    private BuildDataHelper() {
    }

    public static BuildData calculateBuildData(String parentName, String parentFullName, List<BuildData> buildDataList) {
        if (buildDataList == null) {
            return null;
        }
        if (buildDataList.size() == 1) {
            return buildDataList.get(0);
        }
        String projectName = parentFullName.replace(parentName, "");
        if (projectName.endsWith("/")) {
            projectName = projectName.substring(0, projectName.lastIndexOf(47));
        }
        for (BuildData buildData : buildDataList) {
            Set remoteUrls = buildData.getRemoteUrls();
            for (String remoteUrl : remoteUrls) {
                if (!remoteUrl.contains(projectName)) continue;
                return buildData;
            }
        }
        return null;
    }

    @NonNull
    public static ObjectId getCommitSHA1(@NonNull Run<?, ?> build) throws IOException {
        List buildDataList = build.getActions(BuildData.class);
        Job parent = build.getParent();
        BuildData buildData = BuildDataHelper.calculateBuildData(parent.getName(), parent.getFullName(), buildDataList);
        if (buildData == null) {
            throw new IOException(Messages.BuildDataHelper_NoBuildDataError());
        }
        Build b = buildData.lastBuild;
        if (b != null) {
            Revision r = b.marked;
            if (r == null) {
                r = b.revision;
            }
            if (r != null) {
                return r.getSha1();
            }
        }
        throw new IOException(Messages.BuildDataHelper_NoLastRevisionError());
    }
}

