/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.status.sources.misc;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Result;
import hudson.model.Run;
import hudson.util.ListBoxModel;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.github.extension.status.misc.ConditionalResult;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class BetterThanOrEqualBuildResult
extends ConditionalResult {
    private String result;

    @DataBoundConstructor
    public BetterThanOrEqualBuildResult() {
    }

    @DataBoundSetter
    public void setResult(String result) {
        this.result = result;
    }

    public String getResult() {
        return this.result;
    }

    @Override
    public boolean matches(@NonNull Run<?, ?> run) {
        return ((Result)ObjectUtils.defaultIfNull((Object)run.getResult(), (Object)Result.NOT_BUILT)).isBetterOrEqualTo(Result.fromString((String)StringUtils.trimToEmpty((String)this.result)));
    }

    public static BetterThanOrEqualBuildResult betterThanOrEqualTo(Result result, GHCommitState state, String msg) {
        BetterThanOrEqualBuildResult conditional = new BetterThanOrEqualBuildResult();
        conditional.setResult(result.toString());
        conditional.setState(state.name());
        conditional.setMessage(msg);
        return conditional;
    }

    @Extension
    public static class BetterThanOrEqualBuildResultDescriptor
    extends ConditionalResult.ConditionalResultDescriptor {
        private static final Result[] SUPPORTED_RESULTS = new Result[]{Result.SUCCESS, Result.UNSTABLE, Result.FAILURE};

        public String getDisplayName() {
            return "result better than or equal to";
        }

        public ListBoxModel doFillResultItems() {
            ListBoxModel items = new ListBoxModel();
            for (Result supported : SUPPORTED_RESULTS) {
                items.add(supported.toString());
            }
            return items;
        }
    }
}

