/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.status.sources;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import org.jenkinsci.plugins.github.common.ExpandableMessage;
import org.jenkinsci.plugins.github.extension.status.GitHubCommitShaSource;
import org.kohsuke.stapler.DataBoundConstructor;

public class ManuallyEnteredShaSource
extends GitHubCommitShaSource {
    private String sha;

    @DataBoundConstructor
    public ManuallyEnteredShaSource(String sha) {
        this.sha = sha;
    }

    public String getSha() {
        return this.sha;
    }

    @Override
    public String get(@NonNull Run<?, ?> run, @NonNull TaskListener listener) throws IOException, InterruptedException {
        return new ExpandableMessage(this.sha).expandAll(run, listener);
    }

    @Extension
    public static class ManuallyEnteredShaSourceDescriptor
    extends Descriptor<GitHubCommitShaSource> {
        public String getDisplayName() {
            return "Manually entered SHA";
        }
    }
}

