/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.status.sources;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.jenkinsci.plugins.github.common.ExpandableMessage;
import org.jenkinsci.plugins.github.extension.status.GitHubStatusResultSource;
import org.jenkinsci.plugins.github.extension.status.misc.ConditionalResult;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.stapler.DataBoundConstructor;

public class ConditionalStatusResultSource
extends GitHubStatusResultSource {
    private List<ConditionalResult> results;

    @DataBoundConstructor
    public ConditionalStatusResultSource(List<ConditionalResult> results) {
        this.results = results;
    }

    @NonNull
    public List<ConditionalResult> getResults() {
        return (List)ObjectUtils.defaultIfNull(this.results, Collections.emptyList());
    }

    @Override
    public GitHubStatusResultSource.StatusResult get(@NonNull Run<?, ?> run, @NonNull TaskListener listener) throws IOException, InterruptedException {
        for (ConditionalResult conditionalResult : this.getResults()) {
            if (!conditionalResult.matches(run)) continue;
            return new GitHubStatusResultSource.StatusResult((GHCommitState)ObjectUtils.defaultIfNull((Object)((GHCommitState)EnumUtils.getEnum(GHCommitState.class, (String)conditionalResult.getState())), (Object)GHCommitState.ERROR), new ExpandableMessage(conditionalResult.getMessage()).expandAll(run, listener));
        }
        return new GitHubStatusResultSource.StatusResult(GHCommitState.PENDING, new ExpandableMessage("Can't define which status to set").expandAll(run, listener));
    }

    @Extension
    public static class ConditionalStatusResultSourceDescriptor
    extends Descriptor<GitHubStatusResultSource> {
        public String getDisplayName() {
            return "Based on build result manually defined";
        }
    }
}

