/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.status.err;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.github.extension.status.StatusErrorHandler;
import org.kohsuke.stapler.DataBoundConstructor;

public class ChangingBuildStatusErrorHandler
extends StatusErrorHandler {
    private String result;

    @DataBoundConstructor
    public ChangingBuildStatusErrorHandler(String result) {
        this.result = result;
    }

    public String getResult() {
        return this.result;
    }

    @Override
    public boolean handle(Exception e, @NonNull Run<?, ?> run, @NonNull TaskListener listener) {
        Result toSet = Result.fromString((String)StringUtils.trimToEmpty((String)this.result));
        listener.error("[GitHub Commit Status Setter] - %s, setting build result to %s", new Object[]{e.getMessage(), toSet});
        run.setResult(toSet);
        return true;
    }

    @Extension
    public static class ChangingBuildStatusErrorHandlerDescriptor
    extends Descriptor<StatusErrorHandler> {
        private static final Result[] SUPPORTED_RESULTS = new Result[]{Result.FAILURE, Result.UNSTABLE};

        public String getDisplayName() {
            return "Change build status";
        }

        public ListBoxModel doFillResultItems() {
            ListBoxModel items = new ListBoxModel();
            for (Result supported : SUPPORTED_RESULTS) {
                items.add(supported.toString());
            }
            return items;
        }
    }
}

