/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.status;

import com.cloudbees.jenkins.Messages;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.util.ArrayList;
import java.util.List;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.github.common.CombineErrorHandler;
import org.jenkinsci.plugins.github.extension.status.GitHubCommitShaSource;
import org.jenkinsci.plugins.github.extension.status.GitHubReposSource;
import org.jenkinsci.plugins.github.extension.status.GitHubStatusBackrefSource;
import org.jenkinsci.plugins.github.extension.status.GitHubStatusContextSource;
import org.jenkinsci.plugins.github.extension.status.GitHubStatusResultSource;
import org.jenkinsci.plugins.github.extension.status.StatusErrorHandler;
import org.jenkinsci.plugins.github.status.sources.AnyDefinedRepositorySource;
import org.jenkinsci.plugins.github.status.sources.BuildDataRevisionShaSource;
import org.jenkinsci.plugins.github.status.sources.BuildRefBackrefSource;
import org.jenkinsci.plugins.github.status.sources.DefaultCommitContextSource;
import org.jenkinsci.plugins.github.status.sources.DefaultStatusResultSource;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.github.GHRepository;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class GitHubCommitStatusSetter
extends Notifier
implements SimpleBuildStep {
    private GitHubCommitShaSource commitShaSource = new BuildDataRevisionShaSource();
    private GitHubReposSource reposSource = new AnyDefinedRepositorySource();
    private GitHubStatusContextSource contextSource = new DefaultCommitContextSource();
    private GitHubStatusResultSource statusResultSource = new DefaultStatusResultSource();
    private GitHubStatusBackrefSource statusBackrefSource = new BuildRefBackrefSource();
    private List<StatusErrorHandler> errorHandlers = new ArrayList<StatusErrorHandler>();

    @DataBoundConstructor
    public GitHubCommitStatusSetter() {
    }

    @DataBoundSetter
    public void setCommitShaSource(GitHubCommitShaSource commitShaSource) {
        this.commitShaSource = commitShaSource;
    }

    @DataBoundSetter
    public void setReposSource(GitHubReposSource reposSource) {
        this.reposSource = reposSource;
    }

    @DataBoundSetter
    public void setContextSource(GitHubStatusContextSource contextSource) {
        this.contextSource = contextSource;
    }

    @DataBoundSetter
    public void setStatusResultSource(GitHubStatusResultSource statusResultSource) {
        this.statusResultSource = statusResultSource;
    }

    @DataBoundSetter
    public void setStatusBackrefSource(GitHubStatusBackrefSource statusBackrefSource) {
        this.statusBackrefSource = statusBackrefSource;
    }

    @DataBoundSetter
    public void setErrorHandlers(List<StatusErrorHandler> errorHandlers) {
        this.errorHandlers = errorHandlers;
    }

    public GitHubCommitShaSource getCommitShaSource() {
        return this.commitShaSource;
    }

    public GitHubReposSource getReposSource() {
        return this.reposSource;
    }

    public GitHubStatusContextSource getContextSource() {
        return this.contextSource;
    }

    public GitHubStatusResultSource getStatusResultSource() {
        return this.statusResultSource;
    }

    public GitHubStatusBackrefSource getStatusBackrefSource() {
        return this.statusBackrefSource;
    }

    public List<StatusErrorHandler> getErrorHandlers() {
        return this.errorHandlers;
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull TaskListener listener) {
        try {
            String sha = this.getCommitShaSource().get(run, listener);
            List<GHRepository> repos = this.getReposSource().repos(run, listener);
            String contextName = this.getContextSource().context(run, listener);
            String backref = this.getStatusBackrefSource().get(run, listener);
            GitHubStatusResultSource.StatusResult result = this.getStatusResultSource().get(run, listener);
            String message = result.getMsg();
            GHCommitState state = result.getState();
            listener.getLogger().printf("[%s] %s on repos %s (sha:%7.7s) with context:%s%n", this.getDescriptor().getDisplayName(), state, repos, sha, contextName);
            for (GHRepository repo : repos) {
                listener.getLogger().println(Messages.GitHubCommitNotifier_SettingCommitStatus(repo.getHtmlUrl() + "/commit/" + sha));
                repo.createCommitStatus(sha, state, backref, message, contextName);
            }
        }
        catch (Exception e) {
            CombineErrorHandler.errorHandling().withHandlers(this.getErrorHandlers()).handle(e, run, listener);
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public Object readResolve() {
        if (this.getStatusBackrefSource() == null) {
            this.setStatusBackrefSource(new BuildRefBackrefSource());
        }
        return this;
    }

    @Extension
    public static class GitHubCommitStatusSetterDescr
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Set GitHub commit status (universal)";
        }
    }
}

