/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.internal;

import com.cloudbees.jenkins.GitHubWebHook;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.okhttp.api.JenkinsOkHttpClient;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import jenkins.model.Jenkins;
import okhttp3.Cache;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.github.config.GitHubServerConfig;
import org.jenkinsci.plugins.github.internal.GitHubClientCacheOps;
import org.jenkinsci.plugins.github.util.misc.NullSafeFunction;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.HttpConnector;
import org.kohsuke.github.RateLimitHandler;
import org.kohsuke.github.extras.okhttp3.OkHttpConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(value={NoExternalUse.class})
public class GitHubLoginFunction
extends NullSafeFunction<GitHubServerConfig, GitHub> {
    private static final OkHttpClient BASECLIENT = JenkinsOkHttpClient.newClientBuilder((OkHttpClient)new OkHttpClient()).build();
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubLoginFunction.class);

    @Override
    @CheckForNull
    protected GitHub applyNullSafe(@NonNull GitHubServerConfig github) {
        String accessToken = GitHubServerConfig.tokenFor(github.getCredentialsId());
        GitHubBuilder builder = new GitHubBuilder().withOAuthToken(accessToken).withConnector((HttpConnector)this.connector(github)).withRateLimitHandler(RateLimitHandler.FAIL);
        try {
            if (StringUtils.isNotBlank((CharSequence)github.getApiUrl())) {
                builder.withEndpoint(github.getApiUrl());
            }
            LOGGER.debug("Create new GH client with creds id {}", (Object)github.getCredentialsId());
            return builder.build();
        }
        catch (IOException e) {
            LOGGER.warn("Failed to login with creds {}", (Object)github.getCredentialsId(), (Object)e);
            return null;
        }
    }

    @NonNull
    private Proxy getProxy(String apiUrl) {
        Jenkins jenkins = GitHubWebHook.getJenkinsInstance();
        if (jenkins.proxy == null) {
            return Proxy.NO_PROXY;
        }
        try {
            return jenkins.proxy.createProxy(new URL(apiUrl).getHost());
        }
        catch (MalformedURLException e) {
            return jenkins.proxy.createProxy(apiUrl);
        }
    }

    private OkHttpConnector connector(GitHubServerConfig config) {
        OkHttpClient.Builder builder = BASECLIENT.newBuilder().proxy(this.getProxy((String)StringUtils.defaultIfBlank((CharSequence)config.getApiUrl(), (CharSequence)"https://api.github.com")));
        if (config.getClientCacheSize() > 0) {
            Cache cache = (Cache)GitHubClientCacheOps.toCacheDir().apply((Object)config);
            builder.cache(cache);
        }
        return new OkHttpConnector(builder.build());
    }
}

