/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.internal;

import com.cloudbees.jenkins.GitHubWebHook;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Hashing;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import okhttp3.Cache;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.github.GitHubPlugin;
import org.jenkinsci.plugins.github.config.GitHubServerConfig;
import org.jenkinsci.plugins.github.util.FluentIterableWrapper;
import org.jenkinsci.plugins.github.util.misc.NullSafeFunction;
import org.jenkinsci.plugins.github.util.misc.NullSafePredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GitHubClientCacheOps {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubClientCacheOps.class);

    private GitHubClientCacheOps() {
    }

    public static Predicate<GitHubServerConfig> withEnabledCache() {
        return new WithEnabledCache();
    }

    public static Function<GitHubServerConfig, Cache> toCacheDir() {
        return new ToCacheDir();
    }

    public static Function<Cache, String> cacheToName() {
        return new CacheToName();
    }

    public static DirectoryStream.Filter<Path> notInCaches(Set<String> caches) {
        Preconditions.checkNotNull(caches, (Object)"set of active caches can't be null");
        return new NotInCachesFilter(caches);
    }

    public static Path getBaseCacheDir() {
        return new File(GitHubWebHook.getJenkinsInstance().getRootDir(), GitHubPlugin.class.getName() + ".cache").toPath();
    }

    public static void clearRedundantCaches(List<GitHubServerConfig> configs) {
        Path baseCacheDir = GitHubClientCacheOps.getBaseCacheDir();
        if (Files.notExists(baseCacheDir, new LinkOption[0])) {
            return;
        }
        ImmutableSet<String> actualNames = FluentIterableWrapper.from(configs).filter(GitHubClientCacheOps.withEnabledCache()).transform(GitHubClientCacheOps.toCacheDir()).transform(GitHubClientCacheOps.cacheToName()).toSet();
        try (DirectoryStream<Path> caches = Files.newDirectoryStream(baseCacheDir, GitHubClientCacheOps.notInCaches(actualNames));){
            GitHubClientCacheOps.deleteEveryIn(caches);
        }
        catch (IOException e) {
            LOGGER.warn("Can't list cache dirs in {}", (Object)baseCacheDir, (Object)e);
        }
    }

    private static void deleteEveryIn(DirectoryStream<Path> caches) {
        for (Path notActualCache : caches) {
            LOGGER.debug("Deleting redundant cache dir {}", (Object)notActualCache);
            try {
                FileUtils.deleteDirectory((File)notActualCache.toFile());
            }
            catch (IOException e) {
                LOGGER.error("Can't delete cache dir <{}>", (Object)notActualCache, (Object)e);
            }
        }
    }

    private static class WithEnabledCache
    extends NullSafePredicate<GitHubServerConfig> {
        private WithEnabledCache() {
        }

        @Override
        protected boolean applyNullSafe(@NonNull GitHubServerConfig config) {
            return config.getClientCacheSize() > 0;
        }
    }

    private static class ToCacheDir
    extends NullSafeFunction<GitHubServerConfig, Cache> {
        public static final int MB = 0x100000;

        private ToCacheDir() {
        }

        @Override
        protected Cache applyNullSafe(@NonNull GitHubServerConfig config) {
            Preconditions.checkArgument((config.getClientCacheSize() > 0 ? 1 : 0) != 0, (Object)"Cache can't be with size <= 0");
            Path cacheDir = GitHubClientCacheOps.getBaseCacheDir().resolve(ToCacheDir.hashed(config));
            return new Cache(cacheDir.toFile(), (long)config.getClientCacheSize() * 0x100000L);
        }

        private static String hashed(GitHubServerConfig config) {
            return Hashing.murmur3_32().newHasher().putString((CharSequence)StringUtils.trimToEmpty((String)config.getApiUrl()), StandardCharsets.UTF_8).putString((CharSequence)StringUtils.trimToEmpty((String)config.getCredentialsId()), StandardCharsets.UTF_8).hash().toString();
        }
    }

    private static class CacheToName
    extends NullSafeFunction<Cache, String> {
        private CacheToName() {
        }

        @Override
        protected String applyNullSafe(@NonNull Cache cache) {
            return cache.directory().getName();
        }
    }

    private static class NotInCachesFilter
    implements DirectoryStream.Filter<Path> {
        private final Set<String> activeCacheNames;

        NotInCachesFilter(Set<String> activeCacheNames) {
            this.activeCacheNames = activeCacheNames;
        }

        @Override
        public boolean accept(Path entry) {
            if (!Files.isDirectory(entry, new LinkOption[0])) {
                LOGGER.debug("{} is not a directory", (Object)entry);
                return false;
            }
            LOGGER.trace("Trying to find <{}> in active caches list...", (Object)entry);
            return !this.activeCacheNames.contains(String.valueOf(entry.getFileName()));
        }
    }
}

