/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.extension;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Item;
import hudson.model.Job;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Set;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMEvent;
import org.apache.commons.lang3.ObjectUtils;
import org.jenkinsci.plugins.github.extension.GHSubscriberEvent;
import org.jenkinsci.plugins.github.util.misc.NullSafeFunction;
import org.jenkinsci.plugins.github.util.misc.NullSafePredicate;
import org.kohsuke.github.GHEvent;
import org.kohsuke.stapler.Stapler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GHEventsSubscriber
implements ExtensionPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(GHEventsSubscriber.class);
    @CheckForNull
    private transient Boolean hasIsApplicableItem;

    @Deprecated
    protected boolean isApplicable(@Nullable Job<?, ?> project) {
        if (this.checkIsApplicableItem()) {
            return this.isApplicable((Item)project);
        }
        throw new AbstractMethodError("you must override the new overload of isApplicable");
    }

    protected abstract boolean isApplicable(@Nullable Item var1);

    private boolean safeIsApplicable(@Nullable Item item) {
        return this.checkIsApplicableItem() ? this.isApplicable(item) : item instanceof Job && this.isApplicable((Job)item);
    }

    private boolean checkIsApplicableItem() {
        if (this.hasIsApplicableItem == null) {
            boolean implemented = false;
            Class<?> clazz = this.getClass();
            while (clazz != null && clazz != GHEventsSubscriber.class) {
                try {
                    Method isApplicable = clazz.getDeclaredMethod("isApplicable", Item.class);
                    if (isApplicable.getDeclaringClass() == GHEventsSubscriber.class) continue;
                    implemented = !Modifier.isAbstract(isApplicable.getModifiers());
                    break;
                }
                catch (NoSuchMethodException e) {
                    clazz = clazz.getSuperclass();
                }
            }
            this.hasIsApplicableItem = implemented;
        }
        return this.hasIsApplicableItem;
    }

    protected abstract Set<GHEvent> events();

    @Deprecated
    protected void onEvent(GHEvent event, String payload) {
    }

    protected void onEvent(GHSubscriberEvent event) {
        this.onEvent(event.getGHEvent(), (String)event.getPayload());
    }

    public static ExtensionList<GHEventsSubscriber> all() {
        return Jenkins.getInstance().getExtensionList(GHEventsSubscriber.class);
    }

    public static Function<GHEventsSubscriber, Set<GHEvent>> extractEvents() {
        return new NullSafeFunction<GHEventsSubscriber, Set<GHEvent>>(){

            @Override
            protected Set<GHEvent> applyNullSafe(@NonNull GHEventsSubscriber subscriber) {
                return (Set)ObjectUtils.defaultIfNull(subscriber.events(), Collections.emptySet());
            }
        };
    }

    @Deprecated
    public static Predicate<GHEventsSubscriber> isApplicableFor(Job<?, ?> project) {
        return GHEventsSubscriber.isApplicableFor(project);
    }

    public static Predicate<GHEventsSubscriber> isApplicableFor(final Item item) {
        return new NullSafePredicate<GHEventsSubscriber>(){

            @Override
            protected boolean applyNullSafe(@NonNull GHEventsSubscriber subscriber) {
                return subscriber.safeIsApplicable(item);
            }
        };
    }

    public static Predicate<GHEventsSubscriber> isInterestedIn(final GHEvent event) {
        return new NullSafePredicate<GHEventsSubscriber>(){

            @Override
            protected boolean applyNullSafe(@NonNull GHEventsSubscriber subscriber) {
                return ((Set)ObjectUtils.defaultIfNull(subscriber.events(), Collections.emptySet())).contains(event);
            }
        };
    }

    @Deprecated
    public static Function<GHEventsSubscriber, Void> processEvent(GHEvent event, String payload) {
        return GHEventsSubscriber.processEvent(new GHSubscriberEvent(SCMEvent.originOf((HttpServletRequest)Stapler.getCurrentRequest2()), event, payload));
    }

    public static Function<GHEventsSubscriber, Void> processEvent(final GHSubscriberEvent event) {
        return new NullSafeFunction<GHEventsSubscriber, Void>(){

            @Override
            protected Void applyNullSafe(@NonNull GHEventsSubscriber subscriber) {
                try {
                    subscriber.onEvent(event);
                }
                catch (Throwable t) {
                    LOGGER.error("Subscriber {} failed to process {} hook, skipping...", new Object[]{subscriber.getClass().getName(), event, t});
                }
                return null;
            }
        };
    }
}

