/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.config;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.util.Collections;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.github.config.GitHubServerConfig;
import org.jenkinsci.plugins.github.webhook.SignatureAlgorithm;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class HookSecretConfig
extends AbstractDescribableImpl<HookSecretConfig> {
    private String credentialsId;
    private SignatureAlgorithm signatureAlgorithm;

    @DataBoundConstructor
    public HookSecretConfig(String credentialsId, String signatureAlgorithm) {
        this.credentialsId = credentialsId;
        this.signatureAlgorithm = this.parseSignatureAlgorithm(signatureAlgorithm);
    }

    public HookSecretConfig(String credentialsId) {
        this(credentialsId, null);
    }

    @Nullable
    public Secret getHookSecret() {
        return (Secret)GitHubServerConfig.secretFor(this.credentialsId).orNull();
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm != null ? this.signatureAlgorithm : SignatureAlgorithm.getDefault();
    }

    public String getSignatureAlgorithmName() {
        return this.getSignatureAlgorithm().name();
    }

    @Deprecated
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    private Object readResolve() {
        if (this.signatureAlgorithm == null) {
            this.signatureAlgorithm = SignatureAlgorithm.getDefault();
        }
        return this;
    }

    private SignatureAlgorithm parseSignatureAlgorithm(String algorithmName) {
        if (algorithmName == null || algorithmName.trim().isEmpty()) {
            return SignatureAlgorithm.getDefault();
        }
        try {
            return SignatureAlgorithm.valueOf(algorithmName.trim().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return SignatureAlgorithm.getDefault();
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<HookSecretConfig> {
        public String getDisplayName() {
            return "Hook secret configuration";
        }

        public ListBoxModel doFillSignatureAlgorithmItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("SHA-256 (Recommended)", "SHA256");
            items.add("SHA-1 (Legacy)", "SHA1");
            return items;
        }

        public ListBoxModel doFillCredentialsIdItems(@QueryParameter String credentialsId) {
            if (!Jenkins.getInstance().hasPermission(Jenkins.MANAGE)) {
                return new StandardListBoxModel().includeCurrentValue(credentialsId);
            }
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)Jenkins.getInstance(), StringCredentials.class, Collections.emptyList(), CredentialsMatchers.always());
        }

        @NonNull
        public Permission getRequiredGlobalConfigPagePermission() {
            return Jenkins.MANAGE;
        }
    }
}

