/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.config;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMName;
import org.acegisecurity.Authentication;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.github.config.Messages;
import org.jenkinsci.plugins.github.internal.GitHubLoginFunction;
import org.jenkinsci.plugins.github.util.FluentIterableWrapper;
import org.jenkinsci.plugins.github.util.misc.NullSafeFunction;
import org.jenkinsci.plugins.github.util.misc.NullSafePredicate;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.github.GitHub;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubServerConfig
extends AbstractDescribableImpl<GitHubServerConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubServerConfig.class);
    private static final String[] COMMON_PREFIX_HOSTNAMES = new String[]{"git.", "github.", "vcs.", "scm.", "source."};
    public static final String GITHUB_URL = "https://api.github.com";
    private static final String PUBLIC_GITHUB_NAME = "GitHub";
    private static final String UNKNOWN_TOKEN = "UNKNOWN_TOKEN";
    public static final int DEFAULT_CLIENT_CACHE_SIZE_MB = 20;
    @CheckForNull
    private String name;
    private String apiUrl = "https://api.github.com";
    private boolean manageHooks = true;
    private final String credentialsId;
    private int clientCacheSize = 20;
    private transient GitHub cachedClient;

    @DataBoundConstructor
    public GitHubServerConfig(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @DataBoundSetter
    public void setName(@CheckForNull String name) {
        this.name = Util.fixEmptyAndTrim((String)name);
    }

    @DataBoundSetter
    public void setApiUrl(String apiUrl) {
        this.apiUrl = (String)StringUtils.defaultIfBlank((CharSequence)apiUrl, (CharSequence)GITHUB_URL);
    }

    @DataBoundSetter
    public void setManageHooks(boolean manageHooks) {
        this.manageHooks = manageHooks;
    }

    @Deprecated
    public void setCustomApiUrl(boolean customApiUrl) {
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        boolean isGitHubCom;
        String gitHubName = this.getName();
        boolean bl = isGitHubCom = StringUtils.isBlank((CharSequence)this.apiUrl) || GITHUB_URL.equals(this.apiUrl);
        if (StringUtils.isBlank((CharSequence)gitHubName)) {
            gitHubName = isGitHubCom ? PUBLIC_GITHUB_NAME : SCMName.fromUrl((String)this.apiUrl, (String[])COMMON_PREFIX_HOSTNAMES);
        }
        String gitHubUrl = isGitHubCom ? "https://github.com" : StringUtils.removeEnd((String)this.apiUrl, (String)"/api/v3");
        return StringUtils.isBlank((CharSequence)gitHubName) ? gitHubUrl : Messages.GitHubServerConfig_displayName(gitHubName, gitHubUrl);
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public boolean isManageHooks() {
        return this.manageHooks;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public int getClientCacheSize() {
        return this.clientCacheSize;
    }

    @DataBoundSetter
    public void setClientCacheSize(int clientCacheSize) {
        this.clientCacheSize = clientCacheSize;
    }

    protected synchronized GitHub getCachedClient() {
        return this.cachedClient;
    }

    protected synchronized void setCachedClient(GitHub cachedClient) {
        this.cachedClient = cachedClient;
    }

    public static boolean isUrlCustom(String apiUrl) {
        return StringUtils.isNotBlank((CharSequence)apiUrl) && !GITHUB_URL.equals(apiUrl);
    }

    @CheckForNull
    public static Function<GitHubServerConfig, GitHub> loginToGithub() {
        return new ClientCacheFunction();
    }

    @NonNull
    public static String tokenFor(String credentialsId) {
        return ((Secret)GitHubServerConfig.secretFor(credentialsId).or((Supplier)new Supplier<Secret>(){

            public Secret get() {
                return Secret.fromString((String)GitHubServerConfig.UNKNOWN_TOKEN);
            }
        })).getPlainText();
    }

    @NonNull
    public static Optional<Secret> secretFor(String credentialsId) {
        List creds = CredentialsMatchers.filter((List)CredentialsProvider.lookupCredentials(StringCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)StringUtils.trimToEmpty((String)credentialsId)));
        return FluentIterableWrapper.from(creds).transform(new NullSafeFunction<StringCredentials, Secret>(){

            @Override
            protected Secret applyNullSafe(@NonNull StringCredentials input) {
                return input.getSecret();
            }
        }).first();
    }

    public static Predicate<GitHubServerConfig> withHost(final String host) {
        return new NullSafePredicate<GitHubServerConfig>(){

            @Override
            protected boolean applyNullSafe(@NonNull GitHubServerConfig github) {
                return ((String)StringUtils.defaultIfEmpty((CharSequence)github.getApiUrl(), (CharSequence)GitHubServerConfig.GITHUB_URL)).contains(host);
            }
        };
    }

    public static Predicate<GitHubServerConfig> allowedToManageHooks() {
        return new NullSafePredicate<GitHubServerConfig>(){

            @Override
            protected boolean applyNullSafe(@NonNull GitHubServerConfig github) {
                return github.isManageHooks();
            }
        };
    }

    private static class ClientCacheFunction
    extends NullSafeFunction<GitHubServerConfig, GitHub> {
        private ClientCacheFunction() {
        }

        @Override
        protected GitHub applyNullSafe(@NonNull GitHubServerConfig github) {
            if (github.getCachedClient() == null) {
                github.setCachedClient((GitHub)new GitHubLoginFunction().apply(github));
            }
            return github.getCachedClient();
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<GitHubServerConfig> {
        public String getDisplayName() {
            return "GitHub Server";
        }

        @NonNull
        public Permission getRequiredGlobalConfigPagePermission() {
            return Jenkins.MANAGE;
        }

        public ListBoxModel doFillCredentialsIdItems(@QueryParameter String apiUrl, @QueryParameter String credentialsId) {
            if (!Jenkins.getInstance().hasPermission(Jenkins.MANAGE)) {
                return new StandardListBoxModel().includeCurrentValue(credentialsId);
            }
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)Jenkins.getInstance(), StringCredentials.class, URIRequirementBuilder.fromUri((String)((String)StringUtils.defaultIfBlank((CharSequence)apiUrl, (CharSequence)GitHubServerConfig.GITHUB_URL))).build(), CredentialsMatchers.always());
        }

        @RequirePOST
        @Restricted(value={DoNotUse.class})
        public FormValidation doVerifyCredentials(@QueryParameter String apiUrl, @QueryParameter String credentialsId) throws IOException {
            Jenkins.getActiveInstance().checkPermission(Jenkins.MANAGE);
            GitHubServerConfig config = new GitHubServerConfig(credentialsId);
            config.setApiUrl(apiUrl);
            config.setClientCacheSize(0);
            GitHub gitHub = (GitHub)new GitHubLoginFunction().apply(config);
            try {
                if (gitHub != null && gitHub.isCredentialValid()) {
                    return FormValidation.ok((String)"Credentials verified for user %s, rate limit: %s", (Object[])new Object[]{gitHub.getMyself().getLogin(), gitHub.getRateLimit().remaining});
                }
                return FormValidation.error((String)"Failed to validate the account");
            }
            catch (IOException e) {
                return FormValidation.error((Throwable)e, (String)"Failed to validate the account");
            }
        }

        public FormValidation doCheckApiUrl(@QueryParameter String value) {
            try {
                new URL(value);
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)"Malformed GitHub url (%s)", (Object[])new Object[]{e.getMessage()});
            }
            if (GitHubServerConfig.GITHUB_URL.equals(value)) {
                return FormValidation.ok();
            }
            if (value.endsWith("/api/v3") || value.endsWith("/api/v3/")) {
                return FormValidation.ok();
            }
            return FormValidation.warning((String)"GitHub Enterprise API URL ends with \"/api/v3\"");
        }
    }
}

