/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.config;

import com.cloudbees.jenkins.GitHubWebHook;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.thoughtworks.xstream.XStream;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.Permission;
import hudson.util.FormValidation;
import jakarta.inject.Inject;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.main.modules.instance_identity.InstanceIdentity;
import org.jenkinsci.plugins.github.GitHubPlugin;
import org.jenkinsci.plugins.github.Messages;
import org.jenkinsci.plugins.github.config.GitHubServerConfig;
import org.jenkinsci.plugins.github.config.GitHubTokenCredentialsCreator;
import org.jenkinsci.plugins.github.config.HookSecretConfig;
import org.jenkinsci.plugins.github.internal.GHPluginConfigException;
import org.jenkinsci.plugins.github.internal.GitHubClientCacheOps;
import org.jenkinsci.plugins.github.util.FluentIterableWrapper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.github.GitHub;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class GitHubPluginConfig
extends GlobalConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubPluginConfig.class);
    public static final String GITHUB_PLUGIN_CONFIGURATION_ID = "github-plugin-configuration";
    public static final GitHubPluginConfig EMPTY_CONFIG = new GitHubPluginConfig(Collections.emptyList());
    private List<GitHubServerConfig> configs = new ArrayList<GitHubServerConfig>();
    private URL hookUrl;
    @Deprecated
    private transient HookSecretConfig hookSecretConfig;
    private List<HookSecretConfig> hookSecretConfigs;
    @Inject
    private transient InstanceIdentity identity;

    public GitHubPluginConfig() {
        this.getConfigFile().getXStream().alias("github-server-config", GitHubServerConfig.class);
        this.load();
    }

    public GitHubPluginConfig(List<GitHubServerConfig> configs) {
        this.configs = configs;
    }

    private Object readResolve() {
        if (this.hookSecretConfig != null) {
            if (Util.fixEmpty((String)this.hookSecretConfig.getCredentialsId()) != null) {
                this.setHookSecretConfig(this.hookSecretConfig);
            }
            this.hookSecretConfig = null;
        }
        return this;
    }

    @DataBoundSetter
    public void setConfigs(List<GitHubServerConfig> configs) {
        this.configs = configs;
    }

    public List<GitHubServerConfig> getConfigs() {
        return this.configs;
    }

    public boolean isManageHooks() {
        return FluentIterableWrapper.from(this.getConfigs()).filter(GitHubServerConfig.allowedToManageHooks()).first().isPresent();
    }

    @DataBoundSetter
    public void setHookUrl(String hookUrl) {
        this.hookUrl = StringUtils.isEmpty((CharSequence)hookUrl) ? null : this.parseHookUrl(hookUrl);
    }

    @DataBoundSetter
    @Deprecated
    public void setOverrideHookUrl(boolean overrideHookUrl) {
    }

    public URL getHookUrl() throws GHPluginConfigException {
        if (this.hookUrl != null) {
            return this.hookUrl;
        }
        return GitHubPluginConfig.constructDefaultUrl();
    }

    public boolean isOverrideHookUrl() {
        return this.hookUrl != null;
    }

    @Deprecated
    public boolean isOverrideHookURL() {
        return this.isOverrideHookUrl();
    }

    public Iterable<GitHub> findGithubConfig(Predicate<GitHubServerConfig> match) {
        Function<GitHubServerConfig, GitHub> loginFunction = GitHubServerConfig.loginToGithub();
        if (Objects.isNull(loginFunction)) {
            return Collections.emptyList();
        }
        return FluentIterableWrapper.from(this.getConfigs()).filter(match).transform(loginFunction).filter((Predicate<GitHub>)Predicates.notNull());
    }

    public List<Descriptor> actions() {
        return Collections.singletonList(Jenkins.getInstance().getDescriptor(GitHubTokenCredentialsCreator.class));
    }

    public String getId() {
        return GITHUB_PLUGIN_CONFIGURATION_ID;
    }

    protected XmlFile getConfigFile() {
        return new XmlFile((XStream)Jenkins.XSTREAM2, super.getConfigFile().getFile());
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        this.hookSecretConfigs = null;
        try {
            req.bindJSON((Object)this, json);
        }
        catch (Exception e) {
            LOGGER.debug("Problem while submitting form for GitHub Plugin ({})", (Object)e.getMessage(), (Object)e);
            LOGGER.trace("GH form data: {}", (Object)json.toString());
            throw new Descriptor.FormException(String.format("Malformed GitHub Plugin configuration (%s)", e.getMessage()), (Throwable)e, "github-configuration");
        }
        this.save();
        GitHubClientCacheOps.clearRedundantCaches(this.configs);
        return true;
    }

    public String getDisplayName() {
        return "GitHub";
    }

    @RequirePOST
    public FormValidation doReRegister() {
        Jenkins.getActiveInstance().checkPermission(Jenkins.MANAGE);
        if (!GitHubPlugin.configuration().isManageHooks()) {
            return FormValidation.warning((String)"Works only when Jenkins manages hooks (one or more creds specified)");
        }
        List<Item> registered = GitHubWebHook.get().reRegisterAllHooks();
        LOGGER.info("Called registerHooks() for {} items", (Object)registered.size());
        return FormValidation.ok((String)"Called re-register hooks for %s items", (Object[])new Object[]{registered.size()});
    }

    @RequirePOST
    @Restricted(value={DoNotUse.class})
    public FormValidation doCheckHookUrl(@QueryParameter String value) {
        Jenkins.getActiveInstance().checkPermission(Jenkins.MANAGE);
        try {
            HttpURLConnection con = (HttpURLConnection)new URL(value).openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("X-Jenkins-Validation", "true");
            con.connect();
            if (con.getResponseCode() != 200) {
                return FormValidation.error((String)"Got %d from %s", (Object[])new Object[]{con.getResponseCode(), value});
            }
            String v = con.getHeaderField("X-Instance-Identity");
            if (v == null) {
                return FormValidation.warning((String)"It doesn't look like %s is talking to Jenkins. Are you running your own app?", (Object[])new Object[]{value});
            }
            RSAPublicKey key = this.identity.getPublic();
            String expected = new String(Base64.encodeBase64((byte[])key.getEncoded()), Charsets.UTF_8);
            if (!expected.equals(v)) {
                return FormValidation.error((String)"%s is connecting to different Jenkins instances", (Object[])new Object[]{value});
            }
            return FormValidation.ok();
        }
        catch (IOException e) {
            return FormValidation.error((Throwable)e, (String)"Connection test for %s failed", (Object[])new Object[]{value});
        }
    }

    private static URL constructDefaultUrl() {
        String jenkinsUrl = Jenkins.getInstance().getRootUrl();
        GitHubPluginConfig.validateConfig(StringUtils.isNotEmpty((CharSequence)jenkinsUrl), Messages.global_config_url_is_empty());
        try {
            return new URL(jenkinsUrl + GitHubWebHook.get().getUrlName() + "/");
        }
        catch (MalformedURLException e) {
            throw new GHPluginConfigException(Messages.global_config_hook_url_is_malformed(e.getMessage()), new Object[0]);
        }
    }

    private static void validateConfig(boolean state, String message) {
        if (!state) {
            throw new GHPluginConfigException(message, new Object[0]);
        }
    }

    @Deprecated
    public HookSecretConfig getHookSecretConfig() {
        return this.hookSecretConfigs != null && !this.hookSecretConfigs.isEmpty() ? this.hookSecretConfigs.get(0) : new HookSecretConfig(null);
    }

    @Deprecated
    public void setHookSecretConfig(HookSecretConfig hookSecretConfig) {
        this.setHookSecretConfigs(hookSecretConfig.getCredentialsId() != null ? Collections.singletonList(hookSecretConfig) : null);
    }

    public List<HookSecretConfig> getHookSecretConfigs() {
        return this.hookSecretConfigs != null ? Collections.unmodifiableList(new ArrayList<HookSecretConfig>(this.hookSecretConfigs)) : Collections.emptyList();
    }

    @DataBoundSetter
    public void setHookSecretConfigs(List<HookSecretConfig> hookSecretConfigs) {
        this.hookSecretConfigs = hookSecretConfigs != null ? new ArrayList<HookSecretConfig>(hookSecretConfigs) : null;
    }

    private URL parseHookUrl(String hookUrl) {
        try {
            return new URL(hookUrl);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @NonNull
    public Permission getRequiredGlobalConfigPagePermission() {
        return Jenkins.MANAGE;
    }
}

