/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.common;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.jenkinsci.plugins.github.common.ErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombineErrorHandler
implements ErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CombineErrorHandler.class);
    private List<ErrorHandler> handlers = new ArrayList<ErrorHandler>();

    private CombineErrorHandler() {
    }

    public static CombineErrorHandler errorHandling() {
        return new CombineErrorHandler();
    }

    public CombineErrorHandler withHandlers(List<? extends ErrorHandler> handlers) {
        if (CollectionUtils.isNotEmpty(handlers)) {
            this.handlers.addAll(handlers);
        }
        return this;
    }

    @Override
    public boolean handle(Exception e, @NonNull Run<?, ?> run, @NonNull TaskListener listener) {
        LOG.debug("Exception in {} will be processed with {} handlers", new Object[]{run.getParent().getName(), this.handlers.size(), e});
        try {
            for (ErrorHandler next : this.handlers) {
                if (!next.handle(e, run, listener)) continue;
                LOG.debug("Exception in {} [{}] handled by [{}]", new Object[]{run.getParent().getName(), e.getMessage(), next.getClass()});
                return true;
            }
        }
        catch (Exception unhandled) {
            LOG.error("Exception in {} unhandled", (Object)run.getParent().getName(), (Object)unhandled);
            throw new ErrorHandlingException(unhandled);
        }
        throw new ErrorHandlingException(e);
    }

    public static class ErrorHandlingException
    extends RuntimeException {
        public ErrorHandlingException(Throwable cause) {
            super(cause);
        }
    }
}

