/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.admin;

import com.cloudbees.jenkins.GitHubRepositoryName;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.BulkChange;
import hudson.Extension;
import hudson.XmlFile;
import hudson.model.AdministrativeMonitor;
import hudson.model.ManagementLink;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import hudson.util.PersistedList;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.github.Messages;
import org.jenkinsci.plugins.github.admin.GHRepoName;
import org.jenkinsci.plugins.github.admin.RequireAdminRights;
import org.jenkinsci.plugins.github.admin.RespondWithRedirect;
import org.jenkinsci.plugins.github.admin.ValidateRepoName;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class GitHubHookRegisterProblemMonitor
extends AdministrativeMonitor
implements Saveable {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubHookRegisterProblemMonitor.class);
    private transient Map<GitHubRepositoryName, String> problems = new ConcurrentHashMap<GitHubRepositoryName, String>();
    private PersistedList<GitHubRepositoryName> ignored;

    public GitHubHookRegisterProblemMonitor() {
        super(GitHubHookRegisterProblemMonitor.class.getSimpleName());
        PersistedList<GitHubRepositoryName> persistedList;
        this.load();
        if (this.ignored == null) {
            PersistedList<GitHubRepositoryName> persistedList2;
            persistedList = persistedList2;
            super((Saveable)this);
        } else {
            persistedList = this.ignored;
        }
        this.ignored = persistedList;
        this.ignored.setOwner((Saveable)this);
    }

    public Map<GitHubRepositoryName, String> getProblems() {
        return ImmutableMap.copyOf(this.problems);
    }

    public void registerProblem(GitHubRepositoryName repo, Throwable throwable) {
        if (throwable == null) {
            return;
        }
        this.registerProblem(repo, throwable.getMessage());
    }

    private void registerProblem(GitHubRepositoryName repo, String message) {
        if (repo == null) {
            return;
        }
        if (!this.ignored.contains((Object)repo)) {
            this.problems.put(repo, (String)StringUtils.defaultIfBlank((CharSequence)message, (CharSequence)Messages.unknown_error()));
        } else {
            LOGGER.debug("Repo {} is ignored by monitor, skip this problem...", (Object)repo);
        }
    }

    public void resolveProblem(GitHubRepositoryName repo) {
        if (repo == null) {
            return;
        }
        this.problems.remove(repo);
    }

    public boolean isProblemWith(GitHubRepositoryName repo) {
        return this.problems.containsKey(repo);
    }

    public List<GitHubRepositoryName> getIgnored() {
        return this.ignored.toList();
    }

    public String getDisplayName() {
        return Messages.hooks_problem_administrative_monitor_displayname();
    }

    public boolean isActivated() {
        return !this.problems.isEmpty();
    }

    @RequirePOST
    @RequireAdminRights
    public HttpResponse doAct(StaplerRequest2 req) throws IOException {
        if (req.hasParameter("no")) {
            this.disable(true);
            return HttpResponses.redirectViaContextPath((String)"/manage");
        }
        return new HttpRedirect(".");
    }

    @RequirePOST
    @ValidateRepoName
    @RequireAdminRights
    @RespondWithRedirect
    public void doIgnore(@GHRepoName @NonNull GitHubRepositoryName repo) {
        if (!this.ignored.contains((Object)repo)) {
            this.ignored.add((Object)repo);
        }
        this.resolveProblem(repo);
    }

    @RequirePOST
    @ValidateRepoName
    @RequireAdminRights
    @RespondWithRedirect
    public void doDisignore(@GHRepoName @NonNull GitHubRepositoryName repo) {
        this.ignored.remove((Object)repo);
    }

    public synchronized void save() {
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        try {
            this.getConfigFile().write((Object)this);
            SaveableListener.fireOnChange((Saveable)this, (XmlFile)this.getConfigFile());
        }
        catch (IOException e) {
            LOGGER.error("{}", (Throwable)e);
        }
    }

    private synchronized void load() {
        XmlFile file = this.getConfigFile();
        if (!file.exists()) {
            return;
        }
        try {
            file.unmarshal((Object)this);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to load {}", (Object)file, (Object)e);
        }
    }

    private XmlFile getConfigFile() {
        return new XmlFile(new File(Jenkins.getInstance().getRootDir(), ((Object)((Object)this)).getClass().getName() + ".xml"));
    }

    public static GitHubHookRegisterProblemMonitor get() {
        return (GitHubHookRegisterProblemMonitor)((Object)AdministrativeMonitor.all().get(GitHubHookRegisterProblemMonitor.class));
    }

    @Extension
    public static class GitHubHookRegisterProblemManagementLink
    extends ManagementLink {
        @Inject
        private GitHubHookRegisterProblemMonitor monitor;

        public String getIconFileName() {
            return this.monitor.getProblems().isEmpty() && this.monitor.ignored.isEmpty() ? null : "symbol-logo-github plugin-github";
        }

        public String getUrlName() {
            return this.monitor.getUrl();
        }

        public String getDescription() {
            return Messages.hooks_problem_administrative_monitor_description();
        }

        public String getDisplayName() {
            return Messages.hooks_problem_administrative_monitor_displayname();
        }

        protected String getCategoryName() {
            return "TROUBLESHOOTING";
        }
    }
}

