/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.admin;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Ticker;
import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.AdministrativeMonitor;
import hudson.model.Item;
import java.time.Duration;
import java.time.Instant;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.github.Messages;
import org.jenkinsci.plugins.github.extension.GHEventsSubscriber;
import org.jenkinsci.plugins.github.extension.GHSubscriberEvent;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.github.GHEvent;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.json.JsonHttpResponse;
import org.kohsuke.stapler.verb.GET;

@Extension
public class GitHubDuplicateEventsMonitor
extends AdministrativeMonitor {
    @VisibleForTesting
    static final String LAST_DUPLICATE_CLICK_HERE_ANCHOR_ID = GitHubDuplicateEventsMonitor.class.getName() + ".last-duplicate";

    public String getDisplayName() {
        return Messages.duplicate_events_administrative_monitor_displayname();
    }

    public String getDescription() {
        return Messages.duplicate_events_administrative_monitor_description();
    }

    public String getBlurb() {
        return Messages.duplicate_events_administrative_monitor_blurb(LAST_DUPLICATE_CLICK_HERE_ANCHOR_ID, this.getLastDuplicateUrl());
    }

    @VisibleForTesting
    String getLastDuplicateUrl() {
        return this.getUrl() + "/last-duplicate.json";
    }

    public boolean isActivated() {
        return ((DuplicateEventsSubscriber)ExtensionList.lookupSingleton(DuplicateEventsSubscriber.class)).isDuplicateEventSeen();
    }

    public boolean hasRequiredPermission() {
        return Jenkins.get().hasPermission(Jenkins.SYSTEM_READ);
    }

    public void checkRequiredPermission() {
        Jenkins.get().checkPermission(Jenkins.SYSTEM_READ);
    }

    @GET
    @WebMethod(name={"last-duplicate.json"})
    public HttpResponse doGetLastDuplicatePayload() {
        Jenkins.get().checkPermission(Jenkins.SYSTEM_READ);
        DuplicateEventsSubscriber.TrackedDuplicateEvent lastDuplicate = ((DuplicateEventsSubscriber)ExtensionList.lookupSingleton(DuplicateEventsSubscriber.class)).getLastDuplicate();
        JSONObject data = lastDuplicate != null ? JSONObject.fromObject((Object)lastDuplicate.ghSubscriberEvent().getPayload()) : GitHubDuplicateEventsMonitor.getLastDuplicateNoEventPayload();
        return new JsonHttpResponse(data, 200);
    }

    @VisibleForTesting
    static JSONObject getLastDuplicateNoEventPayload() {
        return new JSONObject().accumulate("payload", (Object)"No duplicate events seen yet");
    }

    @Extension
    public static final class DuplicateEventsSubscriber
    extends GHEventsSubscriber {
        private static final Logger LOGGER = Logger.getLogger(DuplicateEventsSubscriber.class.getName());
        private Ticker ticker = Ticker.systemTicker();
        private final Cache<String, Object> eventTracker = Caffeine.newBuilder().maximumSize(24000L).expireAfterWrite(Duration.ofMinutes(10L)).ticker(() -> this.ticker.read()).build();
        private static final Object DUMMY = new Object();
        private volatile TrackedDuplicateEvent lastDuplicate;
        private static final Duration TWENTY_FOUR_HOURS = Duration.ofHours(24L);

        @Restricted(value={NoExternalUse.class})
        @VisibleForTesting
        void setTicker(Ticker testTicker) {
            this.ticker = testTicker;
        }

        @Override
        protected boolean isApplicable(@Nullable Item item) {
            return false;
        }

        @Override
        protected Set<GHEvent> events() {
            return Set.of(GHEvent.CHECK_RUN, GHEvent.CHECK_SUITE, GHEvent.CREATE, GHEvent.DELETE, GHEvent.PULL_REQUEST, GHEvent.PUSH);
        }

        @Override
        protected void onEvent(GHSubscriberEvent event) {
            String eventGuid = event.getEventGuid();
            LOGGER.fine(() -> "Received event with GUID: " + eventGuid);
            if (eventGuid == null) {
                return;
            }
            if (this.eventTracker.getIfPresent((Object)eventGuid) != null) {
                this.lastDuplicate = new TrackedDuplicateEvent(eventGuid, this.getNow(), event);
            }
            this.eventTracker.put((Object)eventGuid, DUMMY);
        }

        public boolean isDuplicateEventSeen() {
            return this.lastDuplicate != null && Duration.between(this.lastDuplicate.lastUpdated(), this.getNow()).compareTo(TWENTY_FOUR_HOURS) < 0;
        }

        private Instant getNow() {
            return Instant.ofEpochSecond(0L, this.ticker.read());
        }

        public TrackedDuplicateEvent getLastDuplicate() {
            return this.lastDuplicate;
        }

        @Restricted(value={NoExternalUse.class})
        @VisibleForTesting
        Set<String> getPresentEventKeys() {
            return this.eventTracker.asMap().keySet().stream().filter(key -> this.eventTracker.getIfPresent(key) != null).collect(Collectors.toSet());
        }

        public record TrackedDuplicateEvent(String eventGuid, Instant lastUpdated, GHSubscriberEvent ghSubscriberEvent) {
        }
    }
}

