/*
 * Decompiled with CFR 0.152.
 */
package com.coravy.hudson.plugins.github;

import org.apache.commons.lang3.StringUtils;

public final class GithubUrl {
    private final String baseUrl;

    private static String normalize(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        if (((String)url).contains("/tree/")) {
            url = ((String)url).replaceFirst("/tree/.*$", "");
        }
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        return url;
    }

    GithubUrl(String input) {
        this.baseUrl = GithubUrl.normalize(input);
    }

    public String toString() {
        return this.baseUrl;
    }

    public String baseUrl() {
        return this.baseUrl;
    }

    public String commitId(String id) {
        return this.baseUrl + "commit/" + id;
    }
}

