/*
 * Decompiled with CFR 0.152.
 */
package com.coravy.hudson.plugins.github;

import com.coravy.hudson.plugins.github.GithubUrl;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import java.util.logging.Logger;
import jenkins.model.ParameterizedJobMixIn;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest2;

public final class GithubProjectProperty
extends JobProperty<Job<?, ?>> {
    private String projectUrl;
    private String displayName;
    private static final Logger LOGGER = Logger.getLogger(GithubProjectProperty.class.getName());

    @DataBoundConstructor
    public GithubProjectProperty(String projectUrlStr) {
        this.projectUrl = new GithubUrl(projectUrlStr).baseUrl();
    }

    public String getProjectUrlStr() {
        return this.projectUrl;
    }

    public GithubUrl getProjectUrl() {
        return new GithubUrl(this.projectUrl);
    }

    @CheckForNull
    public String getDisplayName() {
        return this.displayName;
    }

    @DataBoundSetter
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public static String displayNameFor(@NonNull Job<?, ?> job) {
        GithubProjectProperty ghProp = (GithubProjectProperty)job.getProperty(GithubProjectProperty.class);
        if (ghProp != null && StringUtils.isNotBlank((CharSequence)ghProp.getDisplayName())) {
            return ghProp.getDisplayName();
        }
        return job.getFullName();
    }

    @Extension
    @Symbol(value={"githubProjectProperty"})
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        public static final String GITHUB_PROJECT_BLOCK_NAME = "githubProject";

        public boolean isApplicable(Class<? extends Job> jobType) {
            return ParameterizedJobMixIn.ParameterizedJob.class.isAssignableFrom(jobType);
        }

        public String getDisplayName() {
            return "GitHub project page";
        }

        public JobProperty<?> newInstance(@NonNull StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            GithubProjectProperty tpp = (GithubProjectProperty)((Object)req.bindJSON(GithubProjectProperty.class, formData.getJSONObject(GITHUB_PROJECT_BLOCK_NAME)));
            if (tpp == null) {
                LOGGER.fine("Couldn't bind JSON");
                return null;
            }
            if (tpp.projectUrl == null) {
                LOGGER.fine("projectUrl not found, nullifying GithubProjectProperty");
                return null;
            }
            return tpp;
        }
    }
}

