/*
 * Decompiled with CFR 0.152.
 */
package com.coravy.hudson.plugins.github;

import com.coravy.hudson.plugins.github.GithubProjectProperty;
import com.coravy.hudson.plugins.github.GithubUrl;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Functions;
import hudson.MarkupText;
import hudson.model.Run;
import hudson.plugins.git.GitChangeSet;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

@Extension
public class GithubLinkAnnotator
extends ChangeLogAnnotator {
    private static final Set<String> ALLOWED_URI_SCHEMES = new HashSet<String>();
    private static final LinkMarkup[] MARKUPS;

    public void annotate(Run<?, ?> build, ChangeLogSet.Entry change, MarkupText text) {
        GithubProjectProperty p = (GithubProjectProperty)build.getParent().getProperty(GithubProjectProperty.class);
        if (null == p) {
            return;
        }
        this.annotate(p.getProjectUrl(), text, change);
    }

    void annotate(GithubUrl url, MarkupText text, ChangeLogSet.Entry change) {
        String base = url.baseUrl();
        boolean isValid = GithubLinkAnnotator.verifyUrl(base);
        if (!isValid) {
            throw new IllegalArgumentException("The provided GitHub URL is not valid");
        }
        for (LinkMarkup markup : MARKUPS) {
            markup.process(text, base);
        }
        if (change instanceof GitChangeSet) {
            GitChangeSet cs = (GitChangeSet)change;
            String id = cs.getId();
            text.wrapBy("", String.format(" (<a href='%s'>commit: %s</a>)", Functions.htmlAttributeEscape((String)url.commitId(id)), id.substring(0, Math.min(id.length(), 7))));
        }
    }

    @NonNull
    public static String getAllowedUriSchemes() {
        return StringUtils.join(ALLOWED_URI_SCHEMES, (char)',');
    }

    @CheckReturnValue
    @NonNull
    public static boolean verifyUrl(@CheckForNull String urlString) {
        URI uri;
        if (StringUtils.isBlank((CharSequence)urlString)) {
            return false;
        }
        try {
            uri = new URI(urlString);
        }
        catch (URISyntaxException ex) {
            return false;
        }
        String toCheck = uri.getScheme().toLowerCase();
        return ALLOWED_URI_SCHEMES.contains(toCheck);
    }

    static {
        ALLOWED_URI_SCHEMES.addAll(Arrays.asList("http", "https"));
        MARKUPS = new LinkMarkup[]{new LinkMarkup("(?:C|c)lose(?:s?)\\s(?<!\\:)(?:#)NUM", "issues/$1")};
    }

    private static final class LinkMarkup {
        private final Pattern pattern;
        private final String href;
        private static final Pattern NUM_PATTERN = Pattern.compile("NUM");
        private static final Pattern ANYWORD_PATTERN = Pattern.compile("ANYWORD");

        LinkMarkup(String pattern, String href) {
            pattern = NUM_PATTERN.matcher(pattern).replaceAll("(\\\\d+)");
            pattern = ANYWORD_PATTERN.matcher(pattern).replaceAll("((?:\\\\w|[._-])+)");
            this.pattern = Pattern.compile(pattern);
            this.href = href;
        }

        void process(MarkupText text, String url) {
            for (MarkupText.SubText st : text.findTokens(this.pattern)) {
                st.surroundWith("<a href='" + Functions.htmlAttributeEscape((String)url) + this.href + "'>", "</a>");
            }
        }
    }
}

