/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins;

import com.cloudbees.jenkins.Messages;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.Collections;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.github.common.ExpandableMessage;
import org.jenkinsci.plugins.github.extension.status.GitHubStatusContextSource;
import org.jenkinsci.plugins.github.status.GitHubCommitStatusSetter;
import org.jenkinsci.plugins.github.status.err.ShallowAnyErrorHandler;
import org.jenkinsci.plugins.github.status.sources.AnyDefinedRepositorySource;
import org.jenkinsci.plugins.github.status.sources.BuildDataRevisionShaSource;
import org.jenkinsci.plugins.github.status.sources.ConditionalStatusResultSource;
import org.jenkinsci.plugins.github.status.sources.DefaultCommitContextSource;
import org.jenkinsci.plugins.github.status.sources.misc.AnyBuildResult;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

@Extension
public class GitHubSetCommitStatusBuilder
extends Builder
implements SimpleBuildStep {
    private static final ExpandableMessage DEFAULT_MESSAGE = new ExpandableMessage("");
    private ExpandableMessage statusMessage = DEFAULT_MESSAGE;
    private GitHubStatusContextSource contextSource = new DefaultCommitContextSource();

    @DataBoundConstructor
    public GitHubSetCommitStatusBuilder() {
    }

    public ExpandableMessage getStatusMessage() {
        return this.statusMessage;
    }

    public GitHubStatusContextSource getContextSource() {
        return this.contextSource;
    }

    @DataBoundSetter
    public void setStatusMessage(ExpandableMessage statusMessage) {
        this.statusMessage = statusMessage;
    }

    @DataBoundSetter
    public void setContextSource(GitHubStatusContextSource contextSource) {
        this.contextSource = contextSource;
    }

    public void perform(@NonNull Run<?, ?> build, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        GitHubCommitStatusSetter setter = new GitHubCommitStatusSetter();
        setter.setReposSource(new AnyDefinedRepositorySource());
        setter.setCommitShaSource(new BuildDataRevisionShaSource());
        setter.setContextSource(this.contextSource);
        setter.setErrorHandlers(Collections.singletonList(new ShallowAnyErrorHandler()));
        setter.setStatusResultSource(new ConditionalStatusResultSource(Collections.singletonList(AnyBuildResult.onAnyResult(GHCommitState.PENDING, (String)StringUtils.defaultIfEmpty((CharSequence)(this.statusMessage != null ? this.statusMessage : DEFAULT_MESSAGE).getContent(), (CharSequence)Messages.CommitNotifier_Pending(build.getDisplayName()))))));
        setter.perform(build, workspace, launcher, listener);
    }

    public Object readResolve() {
        if (this.getContextSource() == null) {
            this.setContextSource(new DefaultCommitContextSource());
        }
        return this;
    }

    @Extension
    public static class Descriptor
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.GitHubSetCommitStatusBuilder_DisplayName();
        }
    }
}

