/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins;

import com.cloudbees.jenkins.Messages;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.github.common.ExpandableMessage;
import org.jenkinsci.plugins.github.extension.status.misc.ConditionalResult;
import org.jenkinsci.plugins.github.status.GitHubCommitStatusSetter;
import org.jenkinsci.plugins.github.status.err.ChangingBuildStatusErrorHandler;
import org.jenkinsci.plugins.github.status.err.ShallowAnyErrorHandler;
import org.jenkinsci.plugins.github.status.sources.AnyDefinedRepositorySource;
import org.jenkinsci.plugins.github.status.sources.BuildDataRevisionShaSource;
import org.jenkinsci.plugins.github.status.sources.ConditionalStatusResultSource;
import org.jenkinsci.plugins.github.status.sources.DefaultCommitContextSource;
import org.jenkinsci.plugins.github.status.sources.DefaultStatusResultSource;
import org.jenkinsci.plugins.github.status.sources.misc.AnyBuildResult;
import org.jenkinsci.plugins.github.status.sources.misc.BetterThanOrEqualBuildResult;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubCommitNotifier
extends Notifier
implements SimpleBuildStep {
    private static final ExpandableMessage DEFAULT_MESSAGE = new ExpandableMessage("");
    private ExpandableMessage statusMessage = DEFAULT_MESSAGE;
    private final String resultOnFailure;
    private static final Result[] SUPPORTED_RESULTS = new Result[]{Result.FAILURE, Result.UNSTABLE, Result.SUCCESS};
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubCommitNotifier.class);

    @Restricted(value={NoExternalUse.class})
    public GitHubCommitNotifier() {
        this(GitHubCommitNotifier.getDefaultResultOnFailure().toString());
    }

    @DataBoundConstructor
    public GitHubCommitNotifier(String resultOnFailure) {
        this.resultOnFailure = resultOnFailure;
    }

    public ExpandableMessage getStatusMessage() {
        return this.statusMessage;
    }

    @DataBoundSetter
    public void setStatusMessage(ExpandableMessage statusMessage) {
        this.statusMessage = statusMessage;
    }

    @NonNull
    public String getResultOnFailure() {
        return this.resultOnFailure != null ? this.resultOnFailure : GitHubCommitNotifier.getDefaultResultOnFailure().toString();
    }

    @NonNull
    public static Result getDefaultResultOnFailure() {
        return Result.FAILURE;
    }

    @NonNull
    Result getEffectiveResultOnFailure() {
        return Result.fromString((String)StringUtils.trimToEmpty((String)this.resultOnFailure));
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void perform(@NonNull Run<?, ?> build, @NonNull FilePath ws, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        GitHubCommitStatusSetter setter = new GitHubCommitStatusSetter();
        setter.setReposSource(new AnyDefinedRepositorySource());
        setter.setCommitShaSource(new BuildDataRevisionShaSource());
        setter.setContextSource(new DefaultCommitContextSource());
        String content = (this.statusMessage != null ? this.statusMessage : DEFAULT_MESSAGE).getContent();
        if (StringUtils.isNotBlank((CharSequence)content)) {
            setter.setStatusResultSource(new ConditionalStatusResultSource(Arrays.asList(new ConditionalResult[]{BetterThanOrEqualBuildResult.betterThanOrEqualTo(Result.SUCCESS, GHCommitState.SUCCESS, content), BetterThanOrEqualBuildResult.betterThanOrEqualTo(Result.UNSTABLE, GHCommitState.FAILURE, content), BetterThanOrEqualBuildResult.betterThanOrEqualTo(Result.FAILURE, GHCommitState.ERROR, content), AnyBuildResult.onAnyResult(GHCommitState.PENDING, content)})));
        } else {
            setter.setStatusResultSource(new DefaultStatusResultSource());
        }
        if (this.getEffectiveResultOnFailure().equals(Result.SUCCESS)) {
            setter.setErrorHandlers(Collections.singletonList(new ShallowAnyErrorHandler()));
        } else if (this.resultOnFailure == null) {
            setter.setErrorHandlers(null);
        } else {
            setter.setErrorHandlers(Collections.singletonList(new ChangingBuildStatusErrorHandler(this.getEffectiveResultOnFailure().toString())));
        }
        setter.perform(build, ws, launcher, listener);
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.GitHubCommitNotifier_DisplayName();
        }

        public ListBoxModel doFillResultOnFailureItems() {
            ListBoxModel items = new ListBoxModel();
            for (Result result : SUPPORTED_RESULTS) {
                items.add(result.toString());
            }
            return items;
        }
    }
}

