/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.webhook;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import hudson.model.Job;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRTrigger;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRTriggerMode;
import org.jenkinsci.plugins.github.pullrequest.utils.JobHelper;
import org.jenkinsci.plugins.github.pullrequest.utils.PRHelperFunctions;
import org.jenkinsci.plugins.github.util.JobInfoHelpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebhookInfoPredicates {
    private WebhookInfoPredicates() {
    }

    public static Predicate<Job> withPRTrigger() {
        return Predicates.and((Predicate)JobInfoHelpers.withTrigger(GitHubPRTrigger.class), WebhookInfoPredicates.withHookTriggerMode());
    }

    public static Predicate<Job> withHookTriggerMode() {
        return new HookTriggerMode();
    }

    public static Predicate<Job> withRepo(String repo) {
        return new WithRepo(repo);
    }

    private static class HookTriggerMode
    implements Predicate<Job> {
        private HookTriggerMode() {
        }

        public boolean apply(Job job) {
            return Predicates.in(Arrays.asList(GitHubPRTriggerMode.HEAVY_HOOKS, GitHubPRTriggerMode.HEAVY_HOOKS_CRON, GitHubPRTriggerMode.LIGHT_HOOKS)).apply((Object)((GitHubPRTrigger)((Object)Preconditions.checkNotNull((Object)((Object)JobHelper.ghPRTriggerFromJob(job)), (Object)"This predicate can be applied only for job with GitHubPRTrigger"))).getTriggerMode());
        }
    }

    private static class WithRepo
    implements Predicate<Job> {
        public static final Logger LOG = LoggerFactory.getLogger(WithRepo.class);
        private final String repo;

        WithRepo(String repo) {
            this.repo = repo;
        }

        public boolean apply(Job job) {
            try {
                return StringUtils.equalsIgnoreCase((CharSequence)this.repo, (CharSequence)PRHelperFunctions.asFullRepoName(JobHelper.ghPRTriggerFromJob(job).getRepoFullName(job)));
            }
            catch (Exception ex) {
                LOG.warn("Can't get GitHub repository name for {}. Have you set correct 'GitHub Project Property'?", (Object)job.getFullName(), (Object)ex);
                return false;
            }
        }
    }
}

