/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.webhook;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.Job;
import hudson.security.ACL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.github.extension.GHSubscriberEvent;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRTrigger;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRTriggerMode;
import org.jenkinsci.plugins.github.pullrequest.utils.JobHelper;
import org.jenkinsci.plugins.github.pullrequest.webhook.AbstractGHPullRequestSubsriber;
import org.jenkinsci.plugins.github.pullrequest.webhook.PullRequestInfo;
import org.jenkinsci.plugins.github.pullrequest.webhook.WebhookInfoPredicates;
import org.jenkinsci.plugins.github.util.FluentIterableWrapper;
import org.jenkinsci.plugins.github.util.JobInfoHelpers;
import org.kohsuke.github.GitHub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class GHPullRequestSubscriber
extends AbstractGHPullRequestSubsriber {
    private static final Logger LOGGER = LoggerFactory.getLogger(GHPullRequestSubscriber.class);

    protected boolean isApplicable(Item item) {
        return item instanceof Job && WebhookInfoPredicates.withPRTrigger().apply((Object)((Job)item));
    }

    protected void onEvent(GHSubscriberEvent event) {
        try {
            GitHub gh = GitHub.offline();
            PullRequestInfo info = this.extractPullRequestInfo(event.getGHEvent(), (String)event.getPayload(), gh);
            for (Job job : GHPullRequestSubscriber.getPRTriggerJobs(info.getRepo())) {
                GitHubPRTrigger trigger = JobHelper.ghPRTriggerFromJob(job);
                GitHubPRTriggerMode triggerMode = trigger.getTriggerMode();
                switch (triggerMode) {
                    case HEAVY_HOOKS_CRON: 
                    case HEAVY_HOOKS: {
                        LOGGER.debug("Queued check for {} (PR #{}) after heavy hook", (Object)job.getName(), (Object)info.getNum());
                        trigger.queueRun(job, info.getNum());
                        break;
                    }
                    case LIGHT_HOOKS: {
                        LOGGER.warn("Unsupported LIGHT_HOOKS trigger mode");
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Can't process {} hook", (Object)event, (Object)e);
        }
    }

    static Set<Job> getPRTriggerJobs(String repo) {
        HashSet<Job> ret = new HashSet<Job>();
        ACL.impersonate((Authentication)ACL.SYSTEM, () -> {
            List jobs = Jenkins.getActiveInstance().getAllItems(Job.class);
            ret.addAll((Collection<Job>)FluentIterableWrapper.from((Iterable)jobs).filter(JobInfoHelpers.isBuildable()).filter(WebhookInfoPredicates.withPRTrigger()).filter(WebhookInfoPredicates.withRepo(repo)).toSet());
        });
        return ret;
    }
}

