/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.webhook;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Set;
import org.jenkinsci.plugins.github.extension.GHEventsSubscriber;
import org.jenkinsci.plugins.github.pullrequest.webhook.PullRequestInfo;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GitHub;

public abstract class AbstractGHPullRequestSubsriber
extends GHEventsSubscriber {
    public Set<GHEvent> events() {
        return Sets.immutableEnumSet((Enum)GHEvent.PULL_REQUEST, (Enum[])new GHEvent[]{GHEvent.ISSUE_COMMENT});
    }

    protected PullRequestInfo extractPullRequestInfo(GHEvent event, String payload, GitHub gh) throws IOException {
        switch (event) {
            case ISSUE_COMMENT: {
                GHEventPayload.IssueComment commentPayload = (GHEventPayload.IssueComment)gh.parseEventPayload((Reader)new StringReader(payload), GHEventPayload.IssueComment.class);
                int issueNumber = commentPayload.getIssue().getNumber();
                return new PullRequestInfo(commentPayload.getRepository().getFullName(), issueNumber);
            }
            case PULL_REQUEST: {
                GHEventPayload.PullRequest pr = (GHEventPayload.PullRequest)gh.parseEventPayload((Reader)new StringReader(payload), GHEventPayload.PullRequest.class);
                return new PullRequestInfo(pr.getPullRequest().getRepository().getFullName(), pr.getNumber(), pr.getPullRequest().getBase().getRef());
            }
        }
        throw new IllegalStateException(String.format("Did you add event %s in events() method?", event));
    }
}

