/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.utils;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.util.ListBoxModel;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class StatusVerifier
extends AbstractDescribableImpl<StatusVerifier> {
    private Result buildStatus;

    @DataBoundConstructor
    public StatusVerifier(Result buildStatus) {
        this.buildStatus = buildStatus;
    }

    public boolean isRunAllowed(Run<?, ?> run) {
        return run.getResult().isBetterOrEqualTo(this.buildStatus);
    }

    public Result getBuildStatus() {
        return this.buildStatus;
    }

    @Symbol(value={"allowRunOnStatus"})
    @Extension
    public static class DescriptorImpl
    extends Descriptor<StatusVerifier> {
        public String getDisplayName() {
            return "Allow run only for specified status";
        }

        public ListBoxModel doFillBuildStatusItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(Result.SUCCESS.toString());
            items.add(Result.UNSTABLE.toString());
            items.add(Result.FAILURE.toString());
            return items;
        }
    }
}

