/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.utils;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.util.ListBoxModel;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class PublisherErrorHandler
extends AbstractDescribableImpl<PublisherErrorHandler> {
    private Result buildStatus;

    @DataBoundConstructor
    public PublisherErrorHandler(Result buildStatus) {
        this.buildStatus = buildStatus;
    }

    public Result getBuildStatus() {
        return this.buildStatus;
    }

    public Result markBuildAfterError(Run<?, ?> run) {
        run.setResult(this.buildStatus);
        return this.buildStatus;
    }

    @Symbol(value={"statusOnPublisherError"})
    @Extension
    public static class DescriptorImpl
    extends Descriptor<PublisherErrorHandler> {
        @NonNull
        public String getDisplayName() {
            return "Set build status if publisher failed";
        }

        public ListBoxModel doFillBuildStatusItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(Result.UNSTABLE.toString());
            items.add(Result.FAILURE.toString());
            return items;
        }
    }
}

