/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.utils;

import com.cloudbees.jenkins.GitHubRepositoryName;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import org.jenkinsci.plugins.github.util.misc.NullSafeFunction;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PRHelperFunctions {
    private static final Logger LOGGER = LoggerFactory.getLogger(PRHelperFunctions.class);

    private PRHelperFunctions() {
    }

    public static String asFullRepoName(GitHubRepositoryName repo) {
        Preconditions.checkNotNull((Object)repo, (Object)"Can't get full name from null repo name");
        return String.format("%s/%s", repo.getUserName(), repo.getRepositoryName());
    }

    public static Function<Integer, GHPullRequest> fetchRemotePR(GHRepository ghRepository) {
        return new FetchRemotePRFunction(ghRepository);
    }

    public static Function<GHPullRequest, Integer> extractPRNumber() {
        return new ExtractPRNumberFunction();
    }

    private static class FetchRemotePRFunction
    implements Function<Integer, GHPullRequest> {
        private final GHRepository ghRepository;

        FetchRemotePRFunction(GHRepository ghRepository) {
            this.ghRepository = ghRepository;
        }

        public GHPullRequest apply(Integer input) {
            try {
                return this.ghRepository.getPullRequest(input.intValue());
            }
            catch (IOException e) {
                LOGGER.error("Can't fetch pr by num {}", (Object)input, (Object)e);
                return null;
            }
        }
    }

    private static class ExtractPRNumberFunction
    extends NullSafeFunction<GHPullRequest, Integer> {
        private ExtractPRNumberFunction() {
        }

        protected Integer applyNullSafe(@NonNull GHPullRequest input) {
            return input.getNumber();
        }
    }
}

