/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.utils;

import hudson.util.StreamTaskListener;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class LoggingTaskListenerWrapper
extends StreamTaskListener
implements Closeable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingTaskListenerWrapper.class);

    public LoggingTaskListenerWrapper(File out, Charset charset) throws IOException {
        super(out, charset);
    }

    public PrintWriter error(String msg) {
        LOGGER.error(msg);
        return super.error(msg);
    }

    public PrintWriter error(String format, Object ... args) {
        LOGGER.error(format, args);
        return super.error(MessageFormatter.arrayFormat((String)format, (Object[])args).getMessage());
    }

    public void info(String format, Object ... args) {
        LOGGER.info(format, args);
        this.getLogger().println(MessageFormatter.arrayFormat((String)format, (Object[])args).getMessage());
    }

    public void info(String msg) {
        LOGGER.info(msg);
        this.getLogger().println(msg);
    }

    public void debug(String format, Object ... args) {
        LOGGER.debug(format, args);
        this.getLogger().println(MessageFormatter.arrayFormat((String)format, (Object[])args).getMessage());
    }

    public void debug(String msg) {
        LOGGER.debug(msg);
        this.getLogger().println(msg);
    }
}

