/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.utils;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.AbortException;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildBadgeAction;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Executor;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.QueueTaskFuture;
import hudson.triggers.Trigger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import jenkins.model.CauseOfInterruption;
import jenkins.model.ParameterizedJobMixIn;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRCause;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRTrigger;
import org.jenkinsci.plugins.github.util.JobInfoHelpers;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobHelper {
    private static final Logger LOG = LoggerFactory.getLogger(JobHelper.class);

    private JobHelper() {
    }

    @CheckForNull
    public static GitHubPRTrigger ghPRTriggerFromRun(Run<?, ?> run) {
        return JobHelper.triggerFrom(run.getParent(), GitHubPRTrigger.class);
    }

    @CheckForNull
    public static GitHubPRTrigger ghPRTriggerFromJob(Job<?, ?> job) {
        return JobHelper.triggerFrom(job, GitHubPRTrigger.class);
    }

    @CheckForNull
    public static <T extends Trigger> T triggerFrom(Job<?, ?> job, Class<T> tClass) {
        MatrixProject guessJob = job instanceof MatrixConfiguration ? ((MatrixConfiguration)job).getParent() : job;
        if (guessJob instanceof AbstractProject) {
            AbstractProject abstractProject = (AbstractProject)guessJob;
            return (T)abstractProject.getTrigger(tClass);
        }
        if (guessJob instanceof ParameterizedJobMixIn.ParameterizedJob) {
            ParameterizedJobMixIn.ParameterizedJob pJob = (ParameterizedJobMixIn.ParameterizedJob)guessJob;
            for (Object candidate : pJob.getTriggers().values()) {
                if (!tClass.isInstance(candidate)) continue;
                return (T)((Trigger)tClass.cast(candidate));
            }
        }
        return null;
    }

    @CheckForNull
    public static GitHubPRCause ghPRCauseFromRun(Run<?, ?> run) {
        return JobHelper.ghCauseFromRun(run, GitHubPRCause.class);
    }

    @CheckForNull
    public static <T extends Cause> T ghCauseFromRun(Run<?, ?> run, Class<T> tClass) {
        if (run instanceof MatrixRun) {
            MatrixBuild parentBuild = ((MatrixRun)run).getParentBuild();
            if (Objects.nonNull(parentBuild)) {
                return (T)parentBuild.getCause(tClass);
            }
        } else {
            return (T)run.getCause(tClass);
        }
        return null;
    }

    public static Result getInterruptStatus(Executor executor) throws IllegalAccessException {
        return (Result)FieldUtils.readField((Object)executor, (String)"interruptStatus", (boolean)true);
    }

    public static List<CauseOfInterruption> getInterruptCauses(Executor executor) throws IllegalAccessException {
        return (List)FieldUtils.readField((Object)executor, (String)"causes", (boolean)true);
    }

    public static List<ParameterValue> getDefaultParametersValues(Job<?, ?> job) {
        ParametersDefinitionProperty paramDefProp = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class);
        ArrayList<ParameterValue> defValues = new ArrayList<ParameterValue>();
        if (Objects.isNull(paramDefProp)) {
            return defValues;
        }
        for (ParameterDefinition paramDefinition : paramDefProp.getParameterDefinitions()) {
            ParameterValue defaultValue = paramDefinition.getDefaultParameterValue();
            if (defaultValue == null) continue;
            defValues.add(defaultValue);
        }
        return defValues;
    }

    public static boolean rebuild(Run<?, ?> run) {
        QueueTaskFuture queueTaskFuture = JobInfoHelpers.asParameterizedJobMixIn((Job)run.getParent()).scheduleBuild2(0, new Action[]{run.getAction(ParametersAction.class), run.getAction(CauseAction.class), run.getAction(BuildBadgeAction.class)});
        return queueTaskFuture != null;
    }

    public static GHRepository getGhRepositoryFromPRTrigger(Run<?, ?> run) throws IOException {
        return JobHelper.ghPRTriggerFromRun(run).getRemoteRepository();
    }

    public static int getPRNumberFromPRCause(Run<?, ?> run) throws AbortException {
        GitHubPRCause cause = JobHelper.ghPRCauseFromRun(run);
        if (Objects.isNull((Object)cause)) {
            throw new AbortException("Can't get cause from run/build");
        }
        return cause.getNumber();
    }

    public static GHIssue getGhIssue(Run<?, ?> run) throws IOException {
        return JobHelper.getGhRepositoryFromPRTrigger(run).getIssue(JobHelper.getPRNumberFromPRCause(run));
    }

    public static GHIssue getGhPullRequest(Run<?, ?> run) throws IOException {
        return JobHelper.getGhRepositoryFromPRTrigger(run).getPullRequest(JobHelper.getPRNumberFromPRCause(run));
    }

    public static void addComment(int id, String comment, Run<?, ?> run, TaskListener listener) {
        if (comment == null || comment.trim().isEmpty()) {
            return;
        }
        String finalComment = comment;
        if (Objects.nonNull(run) && Objects.nonNull(listener)) {
            try {
                finalComment = run.getEnvironment(listener).expand(comment);
            }
            catch (Exception e) {
                LOG.error("Error", (Throwable)e);
            }
        }
        try {
            if (Objects.nonNull(run)) {
                GitHubPRTrigger trigger = JobHelper.ghPRTriggerFromRun(run);
                GHRepository ghRepository = trigger.getRemoteRepository();
                ghRepository.getPullRequest(id).comment(finalComment);
            }
        }
        catch (IOException ex) {
            LOG.error("Couldn't add comment to pull request #{}: '{}'", new Object[]{id, finalComment, ex});
        }
    }

    public static GHCommitState getCommitState(Run<?, ?> run, GHCommitState unstableAs) {
        GHCommitState state;
        Result result = run.getResult();
        if (Objects.isNull(result)) {
            LOG.error("{} result is null.", run);
            state = GHCommitState.ERROR;
        } else {
            state = result.isBetterOrEqualTo(Result.SUCCESS) ? GHCommitState.SUCCESS : (result.isBetterOrEqualTo(Result.UNSTABLE) ? unstableAs : GHCommitState.FAILURE);
        }
        return state;
    }
}

