/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.utils;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class IOUtils {
    private IOUtils() {
    }

    public static <T, R> Function<T, R> iof(IOFunction<T, R> fun) {
        return t -> {
            try {
                return fun.apply(t);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        };
    }

    public static <T> Predicate<T> iop(IOPredicate<T> pred) {
        return t -> {
            try {
                return pred.test(t);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        };
    }

    public static <V> V withIo(Supplier<V> supp) throws IOException {
        try {
            return supp.get();
        }
        catch (RuntimeIOException e) {
            throw e.getCause();
        }
    }

    public static void withIo(Runnable run) throws IOException {
        try {
            run.run();
        }
        catch (RuntimeIOException e) {
            throw e.getCause();
        }
    }

    public static <V> void forEachIo(Stream<V> stream, Consumer<V> cons) throws IOException {
        IOUtils.withIo(() -> stream.forEach(cons));
    }

    public static <V> Stream<V> ioOptStream(IOSupplier<V> supp) {
        try {
            V v = supp.get();
            if (v != null) {
                return Stream.of(v);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Stream.empty();
    }

    @FunctionalInterface
    public static interface IOFunction<T, R> {
        public R apply(T var1) throws IOException;
    }

    @FunctionalInterface
    public static interface IOPredicate<T> {
        public boolean test(T var1) throws IOException;
    }

    public static class RuntimeIOException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public RuntimeIOException(IOException e) {
            super(e);
        }

        @Override
        public IOException getCause() {
            return (IOException)super.getCause();
        }
    }

    @FunctionalInterface
    public static interface IOSupplier<T> {
        public T get() throws IOException;
    }
}

