/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.trigger.check;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.jenkinsci.plugins.github.pullrequest.restrictions.GitHubPRUserRestriction;
import org.jenkinsci.plugins.github.pullrequest.utils.LoggingTaskListenerWrapper;
import org.kohsuke.github.GHPullRequest;

public class UserRestrictionFilter
implements Predicate<GHPullRequest> {
    private final LoggingTaskListenerWrapper listener;
    private final GitHubPRUserRestriction userRestriction;

    private UserRestrictionFilter(LoggingTaskListenerWrapper listener, GitHubPRUserRestriction userRestriction) {
        this.listener = listener;
        this.userRestriction = userRestriction;
    }

    public static Predicate<GHPullRequest> withUserRestriction(LoggingTaskListenerWrapper listener, GitHubPRUserRestriction userRestriction) {
        if (Objects.isNull(userRestriction)) {
            return Predicates.alwaysTrue();
        }
        return new UserRestrictionFilter(listener, userRestriction);
    }

    public boolean apply(GHPullRequest remotePR) {
        try {
            if (!this.userRestriction.isWhitelisted(remotePR.getUser())) {
                this.listener.info("Skipping [#{} {}] because of user restriction (user - {})", remotePR.getNumber(), remotePR.getTitle(), remotePR.getUser());
                return false;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return true;
    }
}

