/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.trigger.check;

import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.TaskListener;
import java.util.Objects;
import java.util.function.Predicate;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRPullRequest;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRRepository;
import org.jenkinsci.plugins.github.pullrequest.trigger.check.NotUpdatedPRFilter;
import org.kohsuke.github.GHPullRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipPRInBadState
implements com.google.common.base.Predicate<GHPullRequest>,
Predicate<GHPullRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(NotUpdatedPRFilter.class);
    private final GitHubPRRepository localRepo;
    private final TaskListener logger;

    private SkipPRInBadState(GitHubPRRepository localRepo, TaskListener logger) {
        this.localRepo = localRepo;
        this.logger = logger;
    }

    public static SkipPRInBadState badState(GitHubPRRepository localRepo, TaskListener logger) {
        return new SkipPRInBadState(localRepo, logger);
    }

    public boolean apply(@Nullable GHPullRequest remotePR) {
        if (Objects.isNull(remotePR)) {
            return true;
        }
        GitHubPRPullRequest localPR = this.localRepo.getPulls().get(remotePR.getNumber());
        if (localPR != null && localPR.isInBadState()) {
            this.logger.error("local PR [#{} {}] is in bad state", new Object[]{remotePR.getNumber(), remotePR.getTitle()});
            return false;
        }
        return true;
    }

    @Override
    public boolean test(GHPullRequest remotePR) {
        return this.apply(remotePR);
    }
}

