/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.trigger.check;

import com.github.kostyasha.github.integration.generic.GitHubPRDecisionContext;
import com.github.kostyasha.github.integration.multibranch.GitHubSCMSource;
import com.github.kostyasha.github.integration.multibranch.handler.GitHubPRHandler;
import com.google.common.base.Function;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRCause;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRPullRequest;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRRepository;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRTrigger;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREvent;
import org.kohsuke.github.GHPullRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullRequestToCauseConverter
implements Function<GHPullRequest, GitHubPRCause> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PullRequestToCauseConverter.class);
    private final GitHubPRRepository localRepo;
    private final TaskListener listener;
    @CheckForNull
    private final GitHubPRTrigger trigger;
    @CheckForNull
    private GitHubSCMSource source;
    @CheckForNull
    private final GitHubPRHandler prHandler;

    private PullRequestToCauseConverter(GitHubPRRepository localRepo, TaskListener listener, GitHubPRTrigger trigger) {
        this.localRepo = localRepo;
        this.listener = listener;
        this.trigger = trigger;
        this.prHandler = null;
    }

    public PullRequestToCauseConverter(@NonNull GitHubPRRepository localRepo, @NonNull TaskListener listener, @NonNull GitHubSCMSource source, @NonNull GitHubPRHandler prHandler) {
        this.localRepo = localRepo;
        this.listener = listener;
        this.source = source;
        this.prHandler = prHandler;
        this.trigger = null;
    }

    public static PullRequestToCauseConverter toGitHubPRCause(@NonNull GitHubPRRepository localRepo, @NonNull TaskListener listener, @NonNull GitHubPRTrigger trigger) {
        return new PullRequestToCauseConverter(localRepo, listener, trigger);
    }

    public static PullRequestToCauseConverter toGitHubPRCause(@NonNull GitHubPRRepository localRepo, @NonNull TaskListener listener, @NonNull GitHubPRHandler prHandler, @NonNull GitHubSCMSource source) {
        return new PullRequestToCauseConverter(localRepo, listener, source, prHandler);
    }

    @CheckForNull
    public GitHubPRCause apply(GHPullRequest remotePR) {
        GitHubPRPullRequest localPR = this.localRepo.getPulls().get(remotePR.getNumber());
        GitHubPRDecisionContext context = GitHubPRDecisionContext.newGitHubPRDecisionContext().withListener(this.listener).withLocalPR(localPR).withRemotePR(remotePR).withLocalRepo(this.localRepo).withPrTrigger(this.trigger).withPrHandler(this.prHandler).withSCMSource(this.source).build();
        List causes = this.getEvents().stream().map(e -> this.toCause((GitHubPREvent)((Object)e), context)).filter(Objects::nonNull).collect(Collectors.toList());
        GitHubPRCause cause = (GitHubPRCause)((Object)GitHubPRCause.skipTrigger(causes));
        if (cause != null) {
            LOGGER.debug("Cause [{}] indicated build should be skipped.", (Object)cause);
            this.listener.getLogger().println(String.format("Build of pr %s skipped: %s.", remotePR.getNumber(), cause.getReason()));
            return null;
        }
        if (!causes.isEmpty()) {
            cause = (GitHubPRCause)((Object)causes.get(0));
            LOGGER.debug("Using build cause [{}] as trigger for pr [{}].", (Object)cause, (Object)remotePR.getNumber());
        }
        return cause;
    }

    public List<GitHubPREvent> getEvents() {
        if (Objects.nonNull((Object)this.trigger)) {
            return this.trigger.getEvents();
        }
        if (Objects.nonNull((Object)this.prHandler)) {
            return this.prHandler.getEvents();
        }
        throw new IllegalArgumentException("Can't extract events");
    }

    private GitHubPRCause toCause(GitHubPREvent event, GitHubPRDecisionContext context) {
        try {
            return context.checkEvent(event);
        }
        catch (IOException e) {
            LOGGER.warn("Can't check trigger event", (Throwable)e);
            this.listener.error("Can't check trigger event, so skipping PR #{}. {}", new Object[]{context.getRemotePR().getNumber(), e});
            return null;
        }
    }
}

