/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.trigger.check;

import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRPullRequest;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRRepository;
import org.kohsuke.github.GHPullRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotUpdatedPRFilter
implements com.google.common.base.Predicate<GHPullRequest>,
Predicate<GHPullRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotUpdatedPRFilter.class);
    private final GitHubPRRepository localRepo;
    private final TaskListener logger;

    private NotUpdatedPRFilter(GitHubPRRepository localRepo, TaskListener logger) {
        this.localRepo = localRepo;
        this.logger = logger;
    }

    public static NotUpdatedPRFilter notUpdated(GitHubPRRepository localRepo, TaskListener logger) {
        return new NotUpdatedPRFilter(localRepo, logger);
    }

    public boolean apply(GHPullRequest remotePR) {
        GitHubPRPullRequest localPR = this.localRepo.getPulls().get(remotePR.getNumber());
        if (!NotUpdatedPRFilter.isUpdated(remotePR, localPR)) {
            String logMessage = String.format("PR [#%s %s] not changed", remotePR.getNumber(), remotePR.getTitle());
            this.logger.getLogger().println(logMessage);
            LOGGER.debug(logMessage);
            return false;
        }
        return true;
    }

    @Override
    public boolean test(GHPullRequest remotePR) {
        return this.apply(remotePR);
    }

    private static boolean isUpdated(GHPullRequest remotePR, GitHubPRPullRequest localPR) {
        if (Objects.isNull(localPR)) {
            return true;
        }
        try {
            boolean updated;
            boolean prUpd = new CompareToBuilder().append((Object)localPR.getPrUpdatedAt(), (Object)remotePR.getUpdatedAt()).build() < 0;
            boolean issueUpd = new CompareToBuilder().append((Object)localPR.getIssueUpdatedAt(), (Object)remotePR.getIssueUpdatedAt()).build() < 0;
            boolean headUpd = !StringUtils.equals((CharSequence)localPR.getHeadSha(), (CharSequence)remotePR.getHead().getSha());
            boolean bl = updated = prUpd || issueUpd || headUpd;
            if (updated) {
                LOGGER.info("Pull request #{} was created by {}, last updated: {}", new Object[]{localPR.getNumber(), localPR.getUserLogin(), localPR.getPrUpdatedAt()});
            }
            return updated;
        }
        catch (IOException e) {
            LOGGER.warn("Can't compare PR [#{} {}] with local copy for update", new Object[]{remotePR.getNumber(), remotePR.getTitle(), e});
            return false;
        }
    }
}

