/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.trigger.check;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Objects;
import org.jenkinsci.plugins.github.pullrequest.restrictions.GitHubPRBranchRestriction;
import org.jenkinsci.plugins.github.pullrequest.utils.LoggingTaskListenerWrapper;
import org.kohsuke.github.GHPullRequest;

public class BranchRestrictionFilter
implements Predicate<GHPullRequest> {
    private final LoggingTaskListenerWrapper logger;
    private final GitHubPRBranchRestriction branchRestriction;

    private BranchRestrictionFilter(LoggingTaskListenerWrapper logger, GitHubPRBranchRestriction branchRestriction) {
        this.logger = logger;
        this.branchRestriction = branchRestriction;
    }

    public static Predicate<GHPullRequest> withBranchRestriction(LoggingTaskListenerWrapper logger, GitHubPRBranchRestriction branchRestriction) {
        if (Objects.isNull(branchRestriction)) {
            return Predicates.alwaysTrue();
        }
        return new BranchRestrictionFilter(logger, branchRestriction);
    }

    public boolean apply(GHPullRequest remotePR) {
        if (!this.branchRestriction.isBranchBuildAllowed(remotePR)) {
            this.logger.info("Skipping [#{} {}] because of branch restriction", remotePR.getNumber(), remotePR.getTitle());
            return false;
        }
        return true;
    }
}

