/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.trigger;

import com.cloudbees.jenkins.GitHubWebHook;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.matrix.MatrixRun;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.queue.QueueTaskFuture;
import hudson.model.queue.SubTask;
import hudson.security.ACL;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import jenkins.model.CauseOfInterruption;
import jenkins.model.ParameterizedJobMixIn;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRBadgeAction;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRCause;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRTrigger;
import org.jenkinsci.plugins.github.pullrequest.trigger.NewPRInterruptCause;
import org.jenkinsci.plugins.github.pullrequest.utils.JobHelper;
import org.jenkinsci.plugins.github.util.FluentIterableWrapper;
import org.jenkinsci.plugins.github.util.JobInfoHelpers;
import org.kohsuke.github.GHCommitState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRunnerForCause
implements Predicate<GitHubPRCause> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobRunnerForCause.class);
    private Job<?, ?> job;
    private GitHubPRTrigger trigger;

    public JobRunnerForCause(Job<?, ?> job, GitHubPRTrigger trigger) {
        this.job = job;
        this.trigger = trigger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean apply(GitHubPRCause cause) {
        SecurityContext old = ACL.impersonate((Authentication)ACL.SYSTEM);
        try {
            QueueTaskFuture<?> queueTaskFuture;
            int i;
            cause.setPollingLogFile(this.trigger.getPollingLogAction().getPollingLogFile());
            StringBuilder sb = new StringBuilder();
            sb.append("Jenkins queued the run (").append(cause.getReason()).append(")");
            if (this.trigger.isCancelQueued() && (i = this.cancelQueuedBuildByPrNumber(cause.getNumber())) > 0) {
                sb.append(". ");
                sb.append(i);
                sb.append(" queued builds/runs canceled.");
            }
            if (this.trigger.isAbortRunning()) {
                i = 0;
                try {
                    i = this.abortRunning(cause.getNumber());
                }
                catch (IllegalAccessException e) {
                    LOGGER.error("Can't abort runs/builds for {}", (Object)this.job.getFullName(), (Object)e);
                }
                if (i > 0) {
                    sb.append(". ");
                    sb.append(i);
                    sb.append(" running builds/runs aborted.");
                }
            }
            if (Objects.isNull(queueTaskFuture = this.startJob(cause))) {
                LOGGER.error("{} job didn't start", (Object)this.job.getFullName());
            }
            LOGGER.info(sb.toString());
            if (this.trigger.isPreStatus()) {
                if (this.job instanceof MatrixProject) {
                    Collection configs = ((MatrixProject)this.job).getActiveConfigurations();
                    for (MatrixConfiguration config : configs) {
                        this.trigger.getRemoteRepository().createCommitStatus(cause.getHeadSha(), GHCommitState.PENDING, config.getAbsoluteUrl(), sb.toString(), config.getFullName());
                    }
                } else {
                    this.trigger.getRemoteRepository().createCommitStatus(cause.getHeadSha(), GHCommitState.PENDING, this.job.getAbsoluteUrl(), sb.toString(), this.job.getFullName());
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Can't trigger build:", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)old);
        }
        return true;
    }

    public synchronized int abortRunning(int number) throws IllegalAccessException {
        Computer[] computers;
        int aborted = 0;
        for (Computer computer : computers = GitHubWebHook.getJenkinsInstance().getComputers()) {
            if (Objects.isNull(computer)) continue;
            List executors = computer.getExecutors();
            executors.addAll(computer.getOneOffExecutors());
            for (Executor executor : executors) {
                GitHubPRCause causeAction;
                Job parentJob;
                if (Objects.isNull(executor) || !executor.isBusy() || Objects.nonNull(executor.getCauseOfDeath()) || !JobHelper.getInterruptCauses(executor).isEmpty() || JobHelper.getInterruptStatus(executor) == Result.ABORTED) continue;
                Queue.Executable executable = executor.getCurrentExecutable();
                SubTask parent = executable.getParent();
                if (!(executable instanceof Run)) continue;
                Run executableRun = (Run)executable;
                if (!(parent instanceof Job) || !(parentJob = (Job)parent).getFullName().equals(this.job.getFullName()) || executableRun.getResult() == Result.ABORTED || executableRun instanceof MatrixRun || !Objects.nonNull((Object)(causeAction = (GitHubPRCause)executableRun.getCause(GitHubPRCause.class))) || causeAction.getNumber() != number) continue;
                LOGGER.info("Aborting '{}', by interrupting '{}'", (Object)executableRun, (Object)executor);
                executor.interrupt(Result.ABORTED, new CauseOfInterruption[]{new NewPRInterruptCause()});
                ++aborted;
            }
        }
        return aborted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cancelQueuedBuildByPrNumber(int id) {
        int canceled = 0;
        SecurityContext old = ACL.impersonate((Authentication)ACL.SYSTEM);
        try {
            Queue.Item[] items;
            Queue queue = GitHubWebHook.getJenkinsInstance().getQueue();
            for (Queue.Item item : items = queue.getItems()) {
                if (!(item.task instanceof Job)) {
                    LOGGER.debug("Item {} not instanceof job", (Object)item);
                    continue;
                }
                Job jobTask = (Job)item.task;
                if (!jobTask.getFullName().equals(this.job.getFullName())) {
                    LOGGER.debug("{} != {}", (Object)jobTask.getFullName(), (Object)this.job.getFullName());
                    continue;
                }
                CauseAction action = (CauseAction)item.getAction(CauseAction.class);
                if (Objects.isNull(action)) {
                    LOGGER.debug("Cause action is null for {}", (Object)jobTask.getFullName());
                    continue;
                }
                Optional cause = FluentIterableWrapper.from((Iterable)action.getCauses()).filter(Predicates.instanceOf(GitHubPRCause.class)).firstMatch((Predicate)new CauseHasPRNum(id));
                if (!cause.isPresent()) continue;
                LOGGER.debug("Cancelling {}", (Object)item);
                queue.cancel(item);
                ++canceled;
            }
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)old);
        }
        return canceled;
    }

    public QueueTaskFuture<?> startJob(GitHubPRCause cause) {
        return this.startJob(cause, null);
    }

    public QueueTaskFuture<?> startJob(GitHubPRCause cause, @CheckForNull Cause additionalCause) {
        ParametersAction parametersAction;
        List<ParameterValue> parameters = JobHelper.getDefaultParametersValues(this.job);
        cause.fillParameters(parameters);
        try {
            Constructor constructor = ParametersAction.class.getConstructor(List.class, Collection.class);
            HashSet<String> names = new HashSet<String>();
            for (ParameterValue param : parameters) {
                names.add(param.getName());
            }
            parametersAction = (ParametersAction)constructor.newInstance(parameters, names);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            parametersAction = new ParametersAction(parameters);
        }
        GitHubPRBadgeAction gitHubPRBadgeAction = new GitHubPRBadgeAction(cause);
        ParameterizedJobMixIn parameterizedJobMixIn = JobInfoHelpers.asParameterizedJobMixIn(this.job);
        int quietPeriod = 0;
        try {
            Object mixinJob = FieldUtils.readField((Object)parameterizedJobMixIn, (String)"val$job", (boolean)true);
            ParameterizedJobMixIn.ParameterizedJob parameterizedJob = (ParameterizedJobMixIn.ParameterizedJob)mixinJob;
            quietPeriod = parameterizedJob.getQuietPeriod();
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Couldn't extract quiet period, falling back to {}", (Object)quietPeriod, (Object)e);
        }
        CauseAction causeAction = Objects.nonNull(additionalCause) ? new CauseAction(new Cause[]{cause, additionalCause}) : new CauseAction((Cause)cause);
        return parameterizedJobMixIn.scheduleBuild2(quietPeriod, new Action[]{causeAction, parametersAction, gitHubPRBadgeAction});
    }

    protected static class CauseHasPRNum
    implements Predicate<Cause> {
        private final int id;

        CauseHasPRNum(int id) {
            this.id = id;
        }

        public boolean apply(Cause cause) {
            return ((GitHubPRCause)cause).getNumber() == this.id;
        }
    }

    protected static class CausesFromAction
    implements Function<Action, Iterable<Cause>> {
        protected CausesFromAction() {
        }

        public Iterable<Cause> apply(Action input) {
            return ((CauseAction)input).getCauses();
        }
    }
}

