/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.restrictions;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRTrigger;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubPRUserRestriction
implements Describable<GitHubPRUserRestriction> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubPRUserRestriction.class);
    private final String orgs;
    private final Set<String> orgsSet;
    private final String users;
    private final Set<String> usersSet;

    @DataBoundConstructor
    public GitHubPRUserRestriction(String orgs, String users) {
        this.orgs = orgs;
        this.orgsSet = new HashSet<String>(Arrays.asList(orgs.split(System.lineSeparator())));
        this.users = users;
        this.usersSet = new HashSet<String>(Arrays.asList(users.split(System.lineSeparator())));
    }

    public boolean isWhitelisted(GHUser user) {
        return !GitHubPRUserRestriction.isMyselfUser(user) && this.usersSet.contains(user.getLogin()) || this.isInWhitelistedOrg(user);
    }

    public String getOrgs() {
        return this.orgs;
    }

    public String getUsers() {
        return this.users;
    }

    public boolean isUserMemberOfOrganization(String organisation, GHUser member) throws IOException {
        GitHub github = GitHubPRTrigger.DescriptorImpl.githubFor(URI.create(member.getHtmlUrl().toString()));
        boolean orgHasMember = github.getOrganization(organisation).hasMember(member);
        LOGGER.debug("org.hasMember(member)? user:'{}' org: '{}' == '{}'", new Object[]{member.getLogin(), organisation, orgHasMember ? "yes" : "no"});
        return orgHasMember;
    }

    private boolean isInWhitelistedOrg(@NonNull GHUser user) {
        boolean ret = false;
        for (String organisation : this.orgsSet) {
            try {
                ret = this.isUserMemberOfOrganization(organisation, user);
                if (!ret) continue;
                break;
            }
            catch (IOException e) {
                LOGGER.error("Can't connect retrieve organization data from GitHub", (Throwable)e);
            }
        }
        return ret;
    }

    private static boolean isMyselfUser(GHUser user) {
        boolean ret = false;
        if (Objects.isNull(user)) {
            return false;
        }
        try {
            GitHub github = GitHubPRTrigger.DescriptorImpl.githubFor(URI.create(user.getHtmlUrl().toString()));
            ret = StringUtils.equals((CharSequence)user.getLogin(), (CharSequence)github.getMyself().getLogin());
        }
        catch (IOException e) {
            LOGGER.error("Can't connect retrieve user data from GitHub", (Throwable)e);
        }
        return ret;
    }

    public Descriptor<GitHubPRUserRestriction> getDescriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptor(GitHubPRUserRestriction.class);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<GitHubPRUserRestriction> {
        public final String getDisplayName() {
            return "User restrictions";
        }
    }
}

