/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.restrictions;

import com.google.common.base.Joiner;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubPRBranchRestriction
implements Describable<GitHubPRBranchRestriction> {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubPRBranchRestriction.class);
    private final Set<String> targetBranchList;

    @DataBoundConstructor
    public GitHubPRBranchRestriction(String targetBranch) {
        this(GitHubPRBranchRestriction.split(targetBranch));
    }

    public GitHubPRBranchRestriction(List<String> targetBranches) {
        this.targetBranchList = new HashSet<String>(targetBranches);
        this.targetBranchList.remove("");
    }

    public boolean isBranchBuildAllowed(GHPullRequest remotePR) {
        String branch;
        String branchName = remotePR.getBase().getRef();
        boolean isAllowed = this.targetBranchList.isEmpty();
        Iterator<String> iterator = this.targetBranchList.iterator();
        while (iterator.hasNext() && !(isAllowed = Pattern.compile(branch = iterator.next()).matcher(branchName).matches())) {
        }
        LOGGER.trace("Target branch {} is {} in our whitelist of target branches", (Object)branchName, (Object)(isAllowed ? "" : "not "));
        return isAllowed;
    }

    public Set<String> getTargetBranchList() {
        return this.targetBranchList;
    }

    public String getTargetBranch() {
        return Joiner.on((String)"\n").skipNulls().join(this.targetBranchList);
    }

    public Descriptor<GitHubPRBranchRestriction> getDescriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptor(GitHubPRBranchRestriction.class);
    }

    private static List<String> split(String targetBranch) {
        return Arrays.asList(targetBranch.trim().split(LINE_SEPARATOR));
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<GitHubPRBranchRestriction> {
        public String getDisplayName() {
            return "Target branch";
        }
    }
}

