/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.publishers.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRLabel;
import org.jenkinsci.plugins.github.pullrequest.publishers.GitHubPRAbstractPublisher;
import org.jenkinsci.plugins.github.pullrequest.utils.JobHelper;
import org.jenkinsci.plugins.github.pullrequest.utils.PublisherErrorHandler;
import org.jenkinsci.plugins.github.pullrequest.utils.StatusVerifier;
import org.kohsuke.github.GHLabel;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubPRLabelRemovePublisher
extends GitHubPRAbstractPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubPRLabelRemovePublisher.class);
    private GitHubPRLabel labelProperty;

    @DataBoundConstructor
    public GitHubPRLabelRemovePublisher(GitHubPRLabel labelProperty, StatusVerifier statusVerifier, PublisherErrorHandler errorHandler) {
        super(statusVerifier, errorHandler);
        this.setLabelProperty(labelProperty);
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        if (this.getStatusVerifier() != null && !this.getStatusVerifier().isRunAllowed(run)) {
            return;
        }
        int number = JobHelper.getPRNumberFromPRCause(run);
        try {
            HashSet remoteLabels = JobHelper.getGhIssue(run).getLabels().stream().map(GHLabel::getName).collect(Collectors.toCollection(HashSet::new));
            remoteLabels.removeAll(this.getLabelProperty().getLabelsSet());
            listener.getLogger().println("Removing labels: " + String.valueOf(this.getLabelProperty().getLabelsSet()));
            JobHelper.getGhIssue(run).setLabels(remoteLabels.toArray(new String[remoteLabels.size()]));
        }
        catch (IOException ex) {
            listener.getLogger().println("Couldn't remove label for PR #" + number + String.valueOf(ex));
            LOGGER.error("Couldn't remove label for PR #{}", (Object)number, (Object)ex);
            this.handlePublisherError(run);
        }
    }

    public GitHubPRLabel getLabelProperty() {
        return this.labelProperty;
    }

    public void setLabelProperty(GitHubPRLabel labelProperty) {
        this.labelProperty = labelProperty;
    }

    @Symbol(value={"githubPRRemoveLabels"})
    @Extension
    public static class DescriptorImpl
    extends GitHubPRAbstractPublisher.DescriptorImpl {
        @Override
        public String getDisplayName() {
            return "GitHub PR: remove labels";
        }
    }
}

