/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.publishers.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import java.io.IOException;
import java.util.HashSet;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRLabel;
import org.jenkinsci.plugins.github.pullrequest.publishers.GitHubPRAbstractPublisher;
import org.jenkinsci.plugins.github.pullrequest.utils.JobHelper;
import org.jenkinsci.plugins.github.pullrequest.utils.PublisherErrorHandler;
import org.jenkinsci.plugins.github.pullrequest.utils.StatusVerifier;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHLabel;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubPRLabelAddPublisher
extends GitHubPRAbstractPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubPRLabelAddPublisher.class);
    private GitHubPRLabel labelProperty;

    @DataBoundConstructor
    public GitHubPRLabelAddPublisher(GitHubPRLabel labelProperty, StatusVerifier statusVerifier, PublisherErrorHandler errorHandler) {
        super(statusVerifier, errorHandler);
        this.setLabelProperty(labelProperty);
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        if (this.getStatusVerifier() != null && !this.getStatusVerifier().isRunAllowed(run)) {
            return;
        }
        try {
            HashSet<String> remoteLabels = new HashSet<String>();
            GHIssue ghIssue = JobHelper.getGhIssue(run);
            ghIssue.getLabels().stream().map(GHLabel::getName).collect(Collectors.toList()).forEach(remoteLabels::add);
            remoteLabels.addAll(this.getLabelProperty().getLabelsSet());
            ghIssue.setLabels(remoteLabels.toArray(new String[remoteLabels.size()]));
        }
        catch (IOException ex) {
            int number = JobHelper.getPRNumberFromPRCause(run);
            listener.getLogger().println("Couldn't add label for PR #" + number + ex.getMessage());
            LOGGER.error("Couldn't add label for PR #{}", (Object)number, (Object)ex);
            this.handlePublisherError(run);
        }
    }

    public GitHubPRLabel getLabelProperty() {
        return this.labelProperty;
    }

    public void setLabelProperty(GitHubPRLabel labelProperty) {
        this.labelProperty = labelProperty;
    }

    public BuildStepDescriptor getDescriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptor(GitHubPRLabelAddPublisher.class);
    }

    @Symbol(value={"githubPRAddLabels"})
    @Extension
    public static class DescriptorImpl
    extends GitHubPRAbstractPublisher.DescriptorImpl {
        @Override
        public String getDisplayName() {
            return "GitHub PR: add labels";
        }
    }
}

