/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.publishers.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Api;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRMessage;
import org.jenkinsci.plugins.github.pullrequest.publishers.GitHubPRAbstractPublisher;
import org.jenkinsci.plugins.github.pullrequest.utils.JobHelper;
import org.jenkinsci.plugins.github.pullrequest.utils.PublisherErrorHandler;
import org.jenkinsci.plugins.github.pullrequest.utils.StatusVerifier;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubPRCommentPublisher
extends GitHubPRAbstractPublisher {
    public static final GitHubPRMessage DEFAULT_COMMENT = new GitHubPRMessage("Build ${BUILD_NUMBER} ${BUILD_STATUS}");
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubPRCommentPublisher.class);
    private GitHubPRMessage comment = DEFAULT_COMMENT;

    @Restricted(value={NoExternalUse.class})
    public GitHubPRCommentPublisher() {
        super(null, null);
    }

    @DataBoundConstructor
    public GitHubPRCommentPublisher(GitHubPRMessage comment, StatusVerifier statusVerifier, PublisherErrorHandler errorHandler) {
        super(statusVerifier, errorHandler);
        this.comment = comment;
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        if (this.getStatusVerifier() != null && !this.getStatusVerifier().isRunAllowed(run)) {
            return;
        }
        String message = this.comment.expandAll(run, listener);
        if (message != null && !message.isEmpty()) {
            try {
                JobHelper.getGhPullRequest(run).comment(message);
            }
            catch (IOException ex) {
                LOGGER.error("Couldn't add comment to pull request #{}: '{}'", new Object[]{JobHelper.getPRNumberFromPRCause(run), message, ex});
                this.handlePublisherError(run);
            }
            listener.getLogger().println(message);
        }
    }

    public final Api getApi() {
        return new Api((Object)this);
    }

    public GitHubPRMessage getComment() {
        return this.comment;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptor(GitHubPRCommentPublisher.class);
    }

    @Symbol(value={"githubPRComment"})
    @Extension
    public static class DescriptorImpl
    extends GitHubPRAbstractPublisher.DescriptorImpl {
        @Override
        public String getDisplayName() {
            return "GitHub PR: post comment";
        }
    }
}

