/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.publishers.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Api;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import java.io.IOException;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github.pullrequest.publishers.GitHubPRAbstractPublisher;
import org.jenkinsci.plugins.github.pullrequest.utils.JobHelper;
import org.jenkinsci.plugins.github.pullrequest.utils.PublisherErrorHandler;
import org.jenkinsci.plugins.github.pullrequest.utils.StatusVerifier;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubPRClosePublisher
extends GitHubPRAbstractPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubPRClosePublisher.class);

    @DataBoundConstructor
    public GitHubPRClosePublisher(StatusVerifier statusVerifier, PublisherErrorHandler errorHandler) {
        super(statusVerifier, errorHandler);
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        if (this.getStatusVerifier() != null && !this.getStatusVerifier().isRunAllowed(run)) {
            return;
        }
        String publishedURL = this.getTriggerDescriptor().getPublishedURL();
        if (publishedURL != null && !publishedURL.isEmpty()) {
            try {
                if (JobHelper.getGhIssue(run).getState().equals((Object)GHIssueState.OPEN)) {
                    try {
                        JobHelper.getGhPullRequest(run).close();
                    }
                    catch (IOException ex) {
                        LOGGER.error("Couldn't close the pull request #{}:", (Object)JobHelper.getPRNumberFromPRCause(run), (Object)ex);
                    }
                }
            }
            catch (IOException ex) {
                listener.getLogger().println("Can't close pull request \n" + String.valueOf(ex));
                this.handlePublisherError(run);
            }
        }
    }

    public final Api getApi() {
        return new Api((Object)this);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Symbol(value={"githubPRClosePublisher"})
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "GitHub PR: close PR";
        }
    }
}

