/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.publishers.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractProject;
import hudson.model.Api;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRCause;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRMessage;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRTrigger;
import org.jenkinsci.plugins.github.pullrequest.publishers.GitHubPRAbstractPublisher;
import org.jenkinsci.plugins.github.pullrequest.utils.JobHelper;
import org.jenkinsci.plugins.github.pullrequest.utils.PublisherErrorHandler;
import org.jenkinsci.plugins.github.pullrequest.utils.StatusVerifier;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubPRBuildStatusPublisher
extends GitHubPRAbstractPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubPRBuildStatusPublisher.class);
    private GitHubPRMessage statusMsg = new GitHubPRMessage("${GITHUB_PR_COND_REF} run ended");
    private GHCommitState unstableAs = GHCommitState.FAILURE;
    private BuildMessage buildMessage = new BuildMessage();

    @Restricted(value={NoExternalUse.class})
    public GitHubPRBuildStatusPublisher() {
        super(null, null);
    }

    @DataBoundConstructor
    public GitHubPRBuildStatusPublisher(GitHubPRMessage statusMsg, GHCommitState unstableAs, BuildMessage buildMessage, StatusVerifier statusVerifier, PublisherErrorHandler errorHandler) {
        super(statusVerifier, errorHandler);
        if (statusMsg != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)statusMsg.getContent())) {
            this.statusMsg = statusMsg;
        }
        this.unstableAs = unstableAs;
        this.buildMessage = buildMessage;
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        PrintStream listenerLogger = listener.getLogger();
        String publishedURL = this.getTriggerDescriptor().getJenkinsURL();
        if (this.getStatusVerifier() != null && !this.getStatusVerifier().isRunAllowed(run)) {
            return;
        }
        if (StringUtils.isEmpty((String)publishedURL)) {
            return;
        }
        GHCommitState state = JobHelper.getCommitState(run, this.unstableAs);
        GitHubPRCause c = JobHelper.ghPRCauseFromRun(run);
        String statusMsgValue = this.getStatusMsg().expandAll(run, listener);
        String buildUrl = publishedURL + run.getUrl();
        LOGGER.info("Setting status of {} to {} with url {} and message: {}", new Object[]{c.getHeadSha(), state, buildUrl, statusMsgValue});
        GitHubPRTrigger trigger = JobHelper.ghPRTriggerFromRun(run);
        if (Objects.isNull((Object)trigger)) {
            listener.error("Can't get trigger for this run! Silently skipping. TODO implement error handler, like in publishers");
            return;
        }
        try {
            trigger.getRemoteRepository().createCommitStatus(c.getHeadSha(), state, buildUrl, statusMsgValue, run.getParent().getFullName());
        }
        catch (IOException ex) {
            if (Objects.nonNull((Object)this.buildMessage)) {
                String comment = null;
                LOGGER.error("Could not update commit status of the Pull Request on GitHub. ", (Throwable)ex);
                if (state == GHCommitState.SUCCESS) {
                    comment = this.buildMessage.getSuccessMsg().expandAll(run, listener);
                } else if (state == GHCommitState.FAILURE) {
                    comment = this.buildMessage.getFailureMsg().expandAll(run, listener);
                }
                listenerLogger.println("Adding comment...");
                LOGGER.info("Adding comment, because: ", (Throwable)ex);
                JobHelper.addComment(c.getNumber(), comment, run, listener);
            } else {
                listenerLogger.println("Could not update commit status of the Pull Request on GitHub." + ex.getMessage());
                LOGGER.error("Could not update commit status of the Pull Request on GitHub.", (Throwable)ex);
            }
            this.handlePublisherError(run);
        }
    }

    public final Api getApi() {
        return new Api((Object)this);
    }

    public BuildMessage getBuildMessage() {
        return this.buildMessage;
    }

    public GHCommitState getUnstableAs() {
        return this.unstableAs;
    }

    public GitHubPRMessage getStatusMsg() {
        return this.statusMsg;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static class BuildMessage
    extends AbstractDescribableImpl<BuildMessage> {
        private GitHubPRMessage successMsg = new GitHubPRMessage("Can't set status; build succeeded.");
        private GitHubPRMessage failureMsg = new GitHubPRMessage("Can't set status; build failed.");

        @DataBoundConstructor
        public BuildMessage(GitHubPRMessage successMsg, GitHubPRMessage failureMsg) {
            this.successMsg = successMsg;
            this.failureMsg = failureMsg;
        }

        public BuildMessage() {
        }

        public GitHubPRMessage getSuccessMsg() {
            return this.successMsg;
        }

        public void setSuccessMsg(GitHubPRMessage successMsg) {
            this.successMsg = successMsg;
        }

        public GitHubPRMessage getFailureMsg() {
            return this.failureMsg;
        }

        public void setFailureMsg(GitHubPRMessage failureMsg) {
            this.failureMsg = failureMsg;
        }

        public DescriptorImpl getDescriptor() {
            return (DescriptorImpl)super.getDescriptor();
        }

        @Symbol(value={"message"})
        @Extension
        public static class DescriptorImpl
        extends Descriptor<BuildMessage> {
            @NonNull
            public String getDisplayName() {
                return "Build message container";
            }
        }
    }

    @Symbol(value={"githubPRStatusPublisher"})
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        @NonNull
        public String getDisplayName() {
            return "GitHub PR: set PR status";
        }
    }
}

