/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.pullrequest.publishers;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRTrigger;
import org.jenkinsci.plugins.github.pullrequest.utils.PublisherErrorHandler;
import org.jenkinsci.plugins.github.pullrequest.utils.StatusVerifier;

public abstract class GitHubPRAbstractPublisher
extends Recorder
implements SimpleBuildStep {
    @CheckForNull
    private StatusVerifier statusVerifier;
    @CheckForNull
    private PublisherErrorHandler errorHandler;

    public GitHubPRAbstractPublisher(StatusVerifier statusVerifier, PublisherErrorHandler errorHandler) {
        this.statusVerifier = statusVerifier;
        this.errorHandler = errorHandler;
    }

    public StatusVerifier getStatusVerifier() {
        return this.statusVerifier;
    }

    public PublisherErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    protected void handlePublisherError(Run<?, ?> run) {
        if (this.errorHandler != null) {
            this.errorHandler.markBuildAfterError(run);
        }
    }

    public final BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public final GitHubPRTrigger.DescriptorImpl getTriggerDescriptor() {
        return (GitHubPRTrigger.DescriptorImpl)Jenkins.getInstance().getDescriptor(GitHubPRTrigger.class);
    }

    public static abstract class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public final boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public abstract String getDisplayName();
    }
}

